/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.command.backup;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.worlds.WorldsPlugin;
import net.thenextlvl.worlds.api.view.LevelView;
import net.thenextlvl.worlds.command.WorldCommand;
import net.thenextlvl.worlds.command.argument.CommandFlagsArgument;
import net.thenextlvl.worlds.command.brigadier.SimpleCommand;
import net.thenextlvl.worlds.command.suggestion.BackupSuggestionProvider;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class WorldBackupRestoreCommand
extends SimpleCommand {
    private WorldBackupRestoreCommand(WorldsPlugin plugin) {
        super(plugin, "restore", "worlds.command.backup.restore");
    }

    public static ArgumentBuilder<CommandSourceStack, ?> create(WorldsPlugin plugin) {
        WorldBackupRestoreCommand command = new WorldBackupRestoreCommand(plugin);
        return command.create().then(command.restore());
    }

    private RequiredArgumentBuilder<CommandSourceStack, World> restore() {
        return (RequiredArgumentBuilder)((RequiredArgumentBuilder)WorldCommand.worldArgument(this.plugin).then(this.x((ArgumentBuilder<CommandSourceStack, ?>)Commands.argument((String)"backup", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new BackupSuggestionProvider(this.plugin))))).then(this.x((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal((String)"latest")));
    }

    private ArgumentBuilder<CommandSourceStack, ?> x(ArgumentBuilder<CommandSourceStack, ?> command) {
        return command.then(Commands.argument((String)"flags", (ArgumentType)new CommandFlagsArgument(Set.of("--confirm", "--schedule"))).executes((Command)this)).executes(this::confirmationNeeded);
    }

    private int confirmationNeeded(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        this.plugin.bundle().sendMessage((Audience)sender, "command.confirmation", new TagResolver[]{Placeholder.parsed((String)"action", (String)("/" + context.getInput())), Placeholder.parsed((String)"confirmation", (String)("/" + context.getInput() + " --confirm"))});
        return 0;
    }

    public int run(CommandContext<CommandSourceStack> context) {
        Path path;
        CommandFlagsArgument.Flags flags = (CommandFlagsArgument.Flags)context.getArgument("flags", CommandFlagsArgument.Flags.class);
        if (!flags.contains("--confirm")) {
            return this.confirmationNeeded(context);
        }
        World world = (World)context.getArgument("world", World.class);
        Optional<String> backup = this.tryGetArgument(context, "backup", String.class);
        boolean schedule = flags.contains("--schedule");
        if (!schedule) {
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "world.backup.restore", new TagResolver[]{Placeholder.parsed((String)"world", (String)world.getName())});
        }
        if ((path = (Path)backup.map(name -> this.plugin.levelView().getBackupFolder(world).resolve(name + ".zip")).or(() -> this.plugin.levelView().listBackups(world).min((first, second) -> {
            try {
                FileTime time1 = Files.readAttributes(first, BasicFileAttributes.class, new LinkOption[0]).creationTime();
                FileTime time2 = Files.readAttributes(second, BasicFileAttributes.class, new LinkOption[0]).creationTime();
                return time2.compareTo(time1);
            }
            catch (IOException e) {
                return 0;
            }
        })).orElse(null)) == null) {
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "world.backup.list.empty", new TagResolver[]{Placeholder.parsed((String)"world", (String)world.getName())});
            return 0;
        }
        String string = path.getFileName().toString();
        String backupName = backup.orElse(string.substring(0, string.lastIndexOf(46)));
        ((CompletableFuture)this.plugin.levelView().restoreBackupAsync(world, path, schedule).thenAccept(result -> {
            String message = switch (result.result()) {
                default -> throw new MatchException(null, null);
                case LevelView.DeletionResult.SUCCESS -> "world.backup.restore.success";
                case LevelView.DeletionResult.SCHEDULED -> "world.backup.restore.scheduled";
                case LevelView.DeletionResult.REQUIRES_SCHEDULING -> "world.backup.restore.disallowed";
                case LevelView.DeletionResult.UNLOAD_FAILED -> "world.unload.failed";
                case LevelView.DeletionResult.FAILED -> "world.backup.restore.failed";
            };
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{Placeholder.parsed((String)"world", (String)(result.world() != null ? result.world().getName() : world.getName())), Placeholder.parsed((String)"identifier", (String)backupName)});
        })).exceptionally(throwable -> {
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "world.backup.restore.failed", new TagResolver[]{Placeholder.parsed((String)"world", (String)world.getName()), Placeholder.parsed((String)"identifier", (String)backupName)});
            this.plugin.getComponentLogger().warn("Failed to restore backup of world {} from {}", new Object[]{world.getName(), backupName, throwable});
            return null;
        });
        return 1;
    }
}

