/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.command.argument;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import net.kyori.adventure.key.InvalidKeyException;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.thenextlvl.worlds.command.brigadier.ComponentCommandExceptionType;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class KeyArgument
implements CustomArgumentType<Key, Key> {
    private static final SimpleCommandExceptionType ERROR_INVALID = new ComponentCommandExceptionType((Component)Component.translatable((String)"argument.id.invalid"));

    public Key parse(StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        try {
            String greedy = this.readGreedy(reader);
            if (greedy.contains(":")) {
                return Key.key((String)greedy);
            }
            return Key.key((String)"worlds", (String)greedy);
        }
        catch (InvalidKeyException e) {
            reader.setCursor(cursor);
            throw ERROR_INVALID.createWithContext((ImmutableStringReader)reader);
        }
    }

    public ArgumentType<Key> getNativeType() {
        return ArgumentTypes.key();
    }

    private String readGreedy(StringReader reader) {
        int cursor = reader.getCursor();
        while (reader.canRead() && this.isAllowedInKey(reader.peek())) {
            reader.skip();
        }
        return reader.getString().substring(cursor, reader.getCursor());
    }

    private boolean isAllowedInKey(char character) {
        return Key.allowedInNamespace((char)character) || Key.allowedInValue((char)character) || character == ':';
    }
}

