/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.api.event;

import com.google.common.base.Preconditions;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.function.BiPredicate;
import net.thenextlvl.worlds.api.level.Level;
import org.bukkit.World;
import org.bukkit.event.HandlerList;
import org.bukkit.event.world.WorldEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class WorldCloneEvent
extends WorldEvent {
    private static final HandlerList handlerList = new HandlerList();
    private @Nullable BiPredicate<Path, BasicFileAttributes> fileFilter = null;
    private final Level clone;
    private final boolean full;

    @ApiStatus.Internal
    public WorldCloneEvent(World world, Level clone, boolean full) {
        super(world, false);
        this.clone = clone;
        this.full = full;
    }

    @ApiStatus.Internal
    @Contract(pure=true)
    public @Nullable BiPredicate<Path, BasicFileAttributes> getFileFilter() {
        return this.fileFilter;
    }

    @Contract(pure=true)
    public Level getClone() {
        return this.clone;
    }

    @Contract(mutates="this")
    public void addFileFilter(BiPredicate<Path, BasicFileAttributes> filter) throws IllegalStateException {
        Preconditions.checkState((boolean)this.full, (Object)"Cannot add file filter to non-full clone event");
        this.fileFilter = this.fileFilter != null ? this.fileFilter.and(filter) : filter;
    }

    @Contract(pure=true)
    public boolean isFullClone() {
        return this.full;
    }

    public HandlerList getHandlers() {
        return handlerList;
    }

    public static HandlerList getHandlerList() {
        return handlerList;
    }
}

