/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.api.event;

import java.nio.file.Path;
import java.util.function.Consumer;
import org.bukkit.World;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.world.WorldEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class WorldActionScheduledEvent
extends WorldEvent
implements Cancellable {
    private static final HandlerList handlerList = new HandlerList();
    private @Nullable Consumer<Path> action = null;
    private boolean cancelled = false;
    private final ActionType actionType;

    @ApiStatus.Internal
    public WorldActionScheduledEvent(World world, ActionType actionType) {
        super(world, false);
        this.actionType = actionType;
    }

    @Contract(pure=true)
    public ActionType getActionType() {
        return this.actionType;
    }

    @Contract(mutates="this")
    public void addAction(Consumer<Path> action) {
        this.action = this.action != null ? this.action.andThen(action) : action;
    }

    @ApiStatus.Internal
    public @Nullable Consumer<Path> getAction() {
        return this.action;
    }

    @Contract(pure=true)
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Contract(mutates="this")
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    public HandlerList getHandlers() {
        return handlerList;
    }

    public static HandlerList getHandlerList() {
        return handlerList;
    }

    public static enum ActionType {
        DELETE,
        REGENERATE,
        RESTORE_BACKUP;

    }
}

