/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.command.backup;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.worlds.WorldsPlugin;
import net.thenextlvl.worlds.command.WorldCommand;
import net.thenextlvl.worlds.command.brigadier.SimpleCommand;
import org.bukkit.World;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class WorldBackupListCommand
extends SimpleCommand {
    private WorldBackupListCommand(WorldsPlugin plugin) {
        super(plugin, "list", "worlds.command.backup.list");
    }

    public static ArgumentBuilder<CommandSourceStack, ?> create(WorldsPlugin plugin) {
        WorldBackupListCommand command = new WorldBackupListCommand(plugin);
        return command.create().then(WorldCommand.worldArgument(plugin).executes((Command)command));
    }

    public int run(CommandContext<CommandSourceStack> context) {
        World world = (World)context.getArgument("world", World.class);
        List<Component> backups = this.plugin.levelView().listBackups(world).sorted((first, second) -> {
            try {
                FileTime time1 = Files.readAttributes(first, BasicFileAttributes.class, new LinkOption[0]).creationTime();
                FileTime time2 = Files.readAttributes(second, BasicFileAttributes.class, new LinkOption[0]).creationTime();
                return time2.compareTo(time1);
            }
            catch (IOException e) {
                return 0;
            }
        }).map(path -> {
            String name = path.getFileName().toString();
            String trimmed = name.substring(0, name.lastIndexOf(46));
            long bytes = 0L;
            try {
                bytes = Files.size(path);
            }
            catch (IOException e) {
                this.plugin.getComponentLogger().warn("Failed to calculate backup size for {}", path, (Object)e);
            }
            double kb = (double)bytes / 1024.0;
            double mb = kb / 1024.0;
            double gb = mb / 1024.0;
            FileTime time = FileTime.fromMillis(0L);
            try {
                time = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]).creationTime();
            }
            catch (IOException e) {
                this.plugin.getComponentLogger().warn("Failed to get creation time for {}", path, (Object)e);
            }
            long seconds = (System.currentTimeMillis() - time.toMillis()) / 1000L;
            long minutes = seconds / 60L;
            long hours = minutes / 60L;
            long days = hours / 24L;
            long weeks = days / 7L;
            long months = weeks / 4L;
            long years = months / 12L;
            return this.plugin.bundle().component("world.backup.info", (Audience)((CommandSourceStack)context.getSource()).getSender(), new TagResolver[]{Placeholder.parsed((String)"world", (String)world.key().asString()), Placeholder.parsed((String)"identifier", (String)trimmed), Formatter.number((String)"size", (Number)(gb >= 1.0 ? gb : (mb >= 1.0 ? mb : (kb >= 1.0 ? kb : (double)bytes)))), Formatter.choice((String)"unit", (Number)(gb >= 1.0 ? 0 : (mb >= 1.0 ? 1 : (kb >= 1.0 ? 2 : 3)))), Formatter.number((String)"time", (Number)(years >= 1L ? years : (months >= 1L ? months : (weeks >= 1L ? weeks : (days >= 1L ? days : (hours >= 1L ? hours : (minutes >= 1L ? minutes : seconds))))))), Formatter.choice((String)"timeunit", (Number)(years >= 1L ? 0 : (months >= 1L ? 1 : (weeks >= 1L ? 2 : (days >= 1L ? 3 : (hours >= 1L ? 4 : (minutes >= 1L ? 5 : 6)))))))});
        }).toList();
        String message = backups.isEmpty() ? "world.backup.list.empty" : "world.backup.list";
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{Placeholder.parsed((String)"world", (String)world.getName()), Formatter.number((String)"amount", (Number)backups.size()), Formatter.booleanChoice((String)"singular", (backups.size() == 1 ? 1 : 0) != 0), Formatter.joining((String)"backups", backups)});
        return 1;
    }
}

