/*
 * Decompiled with CFR 0.152.
 */
package dev.faststats.core;

import dev.faststats.core.ErrorTracker;
import dev.faststats.core.SimpleTrackingThreadFactory;
import dev.faststats.core.WrappedTrackingThreadFactory;
import dev.faststats.core.concurrent.TrackingExecutors;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

final class SimpleTrackingExecutors
implements TrackingExecutors {
    private final ErrorTracker tracker;

    public SimpleTrackingExecutors(ErrorTracker tracker) {
        this.tracker = tracker;
    }

    @Override
    public ExecutorService newFixedThreadPool(int threads) {
        return this.tracker.threadPoolExecutor().create(threads, threads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    }

    @Override
    public ExecutorService newWorkStealingPool(int parallelism) {
        return Executors.newWorkStealingPool(parallelism);
    }

    @Override
    public ExecutorService newWorkStealingPool() {
        return Executors.newWorkStealingPool();
    }

    @Override
    public ExecutorService newFixedThreadPool(int threads, ThreadFactory factory) {
        return Executors.newFixedThreadPool(threads, WrappedTrackingThreadFactory.wrap(this.tracker, factory));
    }

    @Override
    public ExecutorService newSingleThreadExecutor() {
        return this.newSingleThreadExecutor(this.defaultThreadFactory());
    }

    @Override
    public ExecutorService newSingleThreadExecutor(ThreadFactory factory) {
        return Executors.newSingleThreadExecutor(WrappedTrackingThreadFactory.wrap(this.tracker, factory));
    }

    @Override
    public ExecutorService newCachedThreadPool() {
        return this.tracker.threadPoolExecutor().create(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }

    @Override
    public ExecutorService newCachedThreadPool(ThreadFactory factory) {
        return Executors.newCachedThreadPool(WrappedTrackingThreadFactory.wrap(this.tracker, factory));
    }

    @Override
    public ExecutorService newThreadPerTaskExecutor(ThreadFactory factory) {
        return Executors.newSingleThreadExecutor(WrappedTrackingThreadFactory.wrap(this.tracker, factory));
    }

    @Override
    public ExecutorService newVirtualThreadPerTaskExecutor() {
        return this.newThreadPerTaskExecutor(Thread.ofVirtual().factory());
    }

    @Override
    public ScheduledExecutorService newSingleThreadScheduledExecutor() {
        return Executors.newSingleThreadScheduledExecutor();
    }

    @Override
    public ScheduledExecutorService newSingleThreadScheduledExecutor(ThreadFactory factory) {
        return Executors.newSingleThreadScheduledExecutor(WrappedTrackingThreadFactory.wrap(this.tracker, factory));
    }

    @Override
    public ScheduledExecutorService newScheduledThreadPool(int corePoolSize) {
        return Executors.newScheduledThreadPool(corePoolSize);
    }

    @Override
    public ScheduledExecutorService newScheduledThreadPool(int corePoolSize, ThreadFactory factory) {
        return Executors.newScheduledThreadPool(corePoolSize, WrappedTrackingThreadFactory.wrap(this.tracker, factory));
    }

    @Override
    public ExecutorService unconfigurableExecutorService(ExecutorService executor) {
        return Executors.unconfigurableExecutorService(executor);
    }

    @Override
    public ScheduledExecutorService unconfigurableScheduledExecutorService(ScheduledExecutorService executor) {
        return Executors.unconfigurableScheduledExecutorService(executor);
    }

    @Override
    public ThreadFactory defaultThreadFactory() {
        return new SimpleTrackingThreadFactory(this.tracker);
    }

    @Override
    public <T> Callable<T> callable(Runnable task, T result) {
        return Executors.callable(this.tracker.base().tracked(task), result);
    }

    @Override
    public Callable<Object> callable(Runnable task) {
        return Executors.callable(this.tracker.base().tracked(task));
    }

    @Override
    public Callable<Object> callable(PrivilegedAction<?> action) {
        return Executors.callable(this.tracker.base().tracked(action));
    }

    @Override
    public Callable<Object> callable(PrivilegedExceptionAction<?> action) {
        return Executors.callable(this.tracker.base().tracked(action));
    }
}

