/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.command.suggestion;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.key.Key;
import net.thenextlvl.worlds.WorldsPlugin;
import net.thenextlvl.worlds.api.link.LinkTree;
import org.bukkit.Keyed;
import org.bukkit.World;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class LinkSuggestionProvider<T>
implements SuggestionProvider<T> {
    private final WorldsPlugin plugin;
    private final boolean unlink;

    public LinkSuggestionProvider(WorldsPlugin plugin, boolean unlink) {
        this.plugin = plugin;
        this.unlink = unlink;
    }

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<T> context, SuggestionsBuilder builder) {
        this.plugin.linkProvider().getLinkTrees().filter(tree -> !this.unlink || !tree.isEmpty()).map(LinkTree::getOverworld).map(Keyed::key).map(Key::asString).filter(s -> s.contains(builder.getRemaining())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    public static class Linked<T>
    implements SuggestionProvider<T> {
        private final WorldsPlugin plugin;

        public Linked(WorldsPlugin plugin) {
            this.plugin = plugin;
        }

        public CompletableFuture<Suggestions> getSuggestions(CommandContext<T> context, SuggestionsBuilder builder) {
            World world = (World)context.getLastChild().getArgument("world", World.class);
            this.plugin.linkProvider().getLinkTree(world).ifPresent(tree -> {
                tree.getPersistedNether().map(Key::asString).filter(s -> s.contains(builder.getRemaining())).ifPresent(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
                tree.getPersistedEnd().map(Key::asString).filter(s -> s.contains(builder.getRemaining())).ifPresent(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            });
            return builder.buildFuture();
        }
    }

    public static class Unlinked<T>
    implements SuggestionProvider<T> {
        private final WorldsPlugin plugin;

        public Unlinked(WorldsPlugin plugin) {
            this.plugin = plugin;
        }

        public CompletableFuture<Suggestions> getSuggestions(CommandContext<T> context, SuggestionsBuilder builder) {
            this.plugin.getServer().getWorlds().stream().filter(world -> !world.getEnvironment().equals((Object)World.Environment.NORMAL) && !world.getEnvironment().equals((Object)World.Environment.CUSTOM)).filter(world -> !this.plugin.linkProvider().hasLinkTree((World)world)).map(Keyed::key).map(Key::asString).filter(s -> s.contains(builder.getRemaining())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }
    }
}

