/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.BlockPositionResolver;
import io.papermc.paper.command.brigadier.argument.resolvers.RotationResolver;
import io.papermc.paper.math.Position;
import io.papermc.paper.math.Rotation;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.thenextlvl.worlds.WorldsPlugin;
import net.thenextlvl.worlds.command.brigadier.SimpleCommand;
import org.bukkit.Location;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class WorldSetSpawnCommand
extends SimpleCommand {
    private WorldSetSpawnCommand(WorldsPlugin plugin, String name) {
        super(plugin, name, "minecraft.command.setworldspawn");
    }

    static LiteralCommandNode<CommandSourceStack> create(WorldsPlugin plugin) {
        return WorldSetSpawnCommand.create(plugin, "setspawn");
    }

    public static LiteralCommandNode<CommandSourceStack> create(WorldsPlugin plugin, String name) {
        WorldSetSpawnCommand command = new WorldSetSpawnCommand(plugin, name);
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)command.create().then(command.positioned())).executes((Command)command)).build();
    }

    private RequiredArgumentBuilder<CommandSourceStack, BlockPositionResolver> positioned() {
        return (RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"position", (ArgumentType)ArgumentTypes.blockPosition()).then(Commands.argument((String)"rotation", (ArgumentType)ArgumentTypes.rotation()).executes((Command)this))).executes((Command)this);
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Location location = ((CommandSourceStack)context.getSource()).getLocation();
        BlockPositionResolver resolver = this.tryGetArgument(context, "position", BlockPositionResolver.class).orElse(null);
        Location position = resolver != null ? (Position)resolver.resolve((CommandSourceStack)context.getSource()) : location;
        RotationResolver rotationResolver = this.tryGetArgument(context, "rotation", RotationResolver.class).orElse(null);
        Rotation rotation = rotationResolver != null ? (Rotation)rotationResolver.resolve((CommandSourceStack)context.getSource()) : Rotation.rotation((float)location.getYaw(), (float)location.getPitch());
        boolean success = location.getWorld().setSpawnLocation(position.toLocation(location.getWorld()).setRotation(rotation));
        String message = success ? "world.spawn.set.success" : "world.spawn.set.failed";
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, Formatter.number((String)"x", (Number)position.blockX()), Formatter.number((String)"y", (Number)position.blockY()), Formatter.number((String)"z", (Number)position.blockZ()), Formatter.number((String)"yaw", (Number)Float.valueOf(rotation.yaw())), Formatter.number((String)"pitch", (Number)Float.valueOf(rotation.pitch())));
        return success ? 1 : 0;
    }
}

