/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.nbt.serialization;

import java.io.File;
import java.lang.reflect.Type;
import java.lang.runtime.SwitchBootstraps;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.thenextlvl.nbt.serialization.NBT;
import net.thenextlvl.nbt.serialization.ParserException;
import net.thenextlvl.nbt.serialization.TagAdapter;
import net.thenextlvl.nbt.serialization.TagDeserializer;
import net.thenextlvl.nbt.serialization.TagSerializer;
import net.thenextlvl.nbt.serialization.adapters.AddressAdapter;
import net.thenextlvl.nbt.serialization.adapters.BooleanAdapter;
import net.thenextlvl.nbt.serialization.adapters.ByteAdapter;
import net.thenextlvl.nbt.serialization.adapters.DoubleAdapter;
import net.thenextlvl.nbt.serialization.adapters.DurationAdapter;
import net.thenextlvl.nbt.serialization.adapters.FileAdapter;
import net.thenextlvl.nbt.serialization.adapters.FloatAdapter;
import net.thenextlvl.nbt.serialization.adapters.IntegerAdapter;
import net.thenextlvl.nbt.serialization.adapters.LongAdapter;
import net.thenextlvl.nbt.serialization.adapters.PathAdapter;
import net.thenextlvl.nbt.serialization.adapters.ShortAdapter;
import net.thenextlvl.nbt.serialization.adapters.StringAdapter;
import net.thenextlvl.nbt.serialization.adapters.UUIDAdapter;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.nbt.tag.IterableTag;
import net.thenextlvl.nbt.tag.ListTag;
import net.thenextlvl.nbt.tag.Tag;

final class SimpleNBT
implements NBT {
    private final SerializationRegistry registry;
    private final boolean prettyPrinting;
    private final int indents;

    private SimpleNBT(SerializationRegistry registry, boolean prettyPrinting, int indents) {
        this.registry = registry;
        this.prettyPrinting = prettyPrinting;
        this.indents = indents;
    }

    @Override
    public <T> T deserialize(Tag tag, Class<T> type) throws ParserException {
        TagDeserializer<?> deserializer = this.registry.hierarchyDeserializers.get(type);
        if (deserializer != null) {
            return (T)deserializer.deserialize(tag, this);
        }
        return (T)this.registry.hierarchyDeserializers.entrySet().stream().filter(entry -> type.isAssignableFrom((Class)entry.getKey())).findAny().map(entry -> ((TagDeserializer)entry.getValue()).deserialize(tag, this)).orElseGet(() -> this.deserialize(tag, (Type)type));
    }

    @Override
    public <T> T deserialize(Tag tag, Type type) throws ParserException {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return this.deserialize(tag, clazz);
        }
        TagDeserializer<?> deserializer = this.registry.deserializers.get(type);
        if (deserializer != null) {
            return (T)deserializer.deserialize(tag, this);
        }
        throw new ParserException("No tag deserializer registered for type: " + String.valueOf(type));
    }

    @Override
    public Tag serialize(Object object) throws ParserException {
        return this.serialize(object, object.getClass());
    }

    @Override
    public Tag serialize(Object object, Class<?> type) throws ParserException {
        TagSerializer<?> serializer = this.registry.hierarchySerializers.get(object.getClass());
        if (serializer != null) {
            return serializer.serialize(object, this);
        }
        return this.registry.hierarchySerializers.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isInstance(object)).findAny().map(entry -> (TagSerializer)entry.getValue()).map(value -> value.serialize(object, this)).orElseGet(() -> this.serialize(object, (Type)object.getClass()));
    }

    @Override
    public Tag serialize(Object object, Type type) throws ParserException {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return this.serialize(object, clazz);
        }
        TagSerializer<?> serializer = this.registry.serializers.get(type);
        if (serializer != null) {
            return serializer.serialize(object, this);
        }
        throw new ParserException("No tag serializer registered for type: " + String.valueOf(type));
    }

    @Override
    public boolean isPrettyPrinting() {
        return this.prettyPrinting;
    }

    @Override
    public int getIndents() {
        return this.indents;
    }

    @Override
    public String toString(Tag tag) {
        return this.prettyPrinting ? "\"\": " + this.prettify(tag, 0) : tag.toString();
    }

    private String prettify(Tag tag, int depth) {
        String indent = " ".repeat(this.indents);
        String currentIndent = indent.repeat(depth);
        Tag tag2 = tag;
        Objects.requireNonNull(tag2);
        Tag tag3 = tag2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CompoundTag.class, ListTag.class, IterableTag.class}, (Object)tag3, n)) {
            case 0 -> {
                CompoundTag compoundTag = (CompoundTag)tag3;
                StringBuilder builder = new StringBuilder("{");
                for (Map.Entry<String, Tag> entry : compoundTag.entrySet()) {
                    builder.append("\n");
                    builder.append(indent.repeat(depth + 1)).append(entry.getKey()).append(": ").append(this.prettify(entry.getValue(), depth + 1));
                }
                yield builder.append("\n").append(currentIndent).append("}").toString();
            }
            case 1 -> {
                ListTag listTag = (ListTag)tag3;
                StringBuilder builder = new StringBuilder("[");
                boolean first = true;
                for (Tag value : listTag) {
                    if (!first) {
                        builder.append(",");
                    }
                    first = false;
                    builder.append("\n");
                    builder.append(indent.repeat(depth + 1)).append(this.prettify(value, depth + 1));
                }
                yield builder.append("\n").append(currentIndent).append("]").toString();
            }
            case 2 -> {
                IterableTag iterableTag = (IterableTag)((Object)tag3);
                StringBuilder builder = new StringBuilder("[ ");
                for (int i = 0; i < iterableTag.size(); ++i) {
                    if (i > 0) {
                        builder.append(", ");
                    }
                    Object obj = iterableTag.get(i);
                    builder.append(obj);
                    if (obj instanceof Long) {
                        builder.append("l");
                        continue;
                    }
                    if (!(obj instanceof Byte)) continue;
                    builder.append("b");
                }
                yield builder.append(" ]").toString();
            }
            default -> tag.toString();
        };
    }

    private record SerializationRegistry(Map<Class<?>, TagDeserializer<?>> hierarchyDeserializers, Map<Class<?>, TagSerializer<?>> hierarchySerializers, Map<Type, TagDeserializer<?>> deserializers, Map<Type, TagSerializer<?>> serializers) {
        public SerializationRegistry() {
            this(new HashMap(), new HashMap(), new HashMap(), new HashMap());
            this.registerTypeAdapter((Type)((Object)Boolean.class), BooleanAdapter.INSTANCE);
            this.registerTypeAdapter((Type)((Object)Byte.class), ByteAdapter.INSTANCE);
            this.registerTypeAdapter((Type)((Object)Double.class), DoubleAdapter.INSTANCE);
            this.registerTypeAdapter((Type)((Object)Duration.class), DurationAdapter.INSTANCE);
            this.registerTypeAdapter((Type)((Object)File.class), FileAdapter.INSTANCE);
            this.registerTypeAdapter((Type)((Object)Float.class), FloatAdapter.INSTANCE);
            this.registerTypeAdapter((Type)((Object)InetSocketAddress.class), AddressAdapter.INSTANCE);
            this.registerTypeAdapter((Type)((Object)Integer.class), IntegerAdapter.INSTANCE);
            this.registerTypeAdapter((Type)((Object)Long.class), LongAdapter.INSTANCE);
            this.registerTypeAdapter((Type)((Object)Path.class), PathAdapter.INSTANCE);
            this.registerTypeAdapter((Type)((Object)Short.class), ShortAdapter.INSTANCE);
            this.registerTypeAdapter((Type)((Object)String.class), StringAdapter.INSTANCE);
            this.registerTypeAdapter((Type)((Object)UUID.class), UUIDAdapter.INSTANCE);
            this.registerTypeAdapter((Type)Boolean.TYPE, BooleanAdapter.INSTANCE);
            this.registerTypeAdapter((Type)Byte.TYPE, ByteAdapter.INSTANCE);
            this.registerTypeAdapter((Type)Double.TYPE, DoubleAdapter.INSTANCE);
            this.registerTypeAdapter((Type)Float.TYPE, FloatAdapter.INSTANCE);
            this.registerTypeAdapter((Type)Integer.TYPE, IntegerAdapter.INSTANCE);
            this.registerTypeAdapter((Type)Long.TYPE, LongAdapter.INSTANCE);
            this.registerTypeAdapter((Type)Short.TYPE, ShortAdapter.INSTANCE);
        }

        public void registerTypeHierarchyAdapter(Class<?> clazz, TagAdapter<?> adapter) {
            this.hierarchyDeserializers.put(clazz, adapter);
            this.hierarchySerializers.put(clazz, adapter);
        }

        public void registerTypeHierarchyAdapter(Class<?> clazz, TagDeserializer<?> deserializer) {
            this.hierarchyDeserializers.put(clazz, deserializer);
        }

        public void registerTypeHierarchyAdapter(Class<?> clazz, TagSerializer<?> serializer) {
            this.hierarchySerializers.put(clazz, serializer);
        }

        public void registerTypeAdapter(Type type, TagAdapter<?> adapter) {
            this.deserializers.put(type, adapter);
            this.serializers.put(type, adapter);
        }

        public void registerTypeAdapter(Type type, TagDeserializer<?> deserializer) {
            this.deserializers.put(type, deserializer);
        }

        public void registerTypeAdapter(Type type, TagSerializer<?> serializer) {
            this.serializers.put(type, serializer);
        }

        public SerializationRegistry immutableCopy() {
            return new SerializationRegistry(Map.copyOf(this.hierarchyDeserializers), Map.copyOf(this.hierarchySerializers), Map.copyOf(this.deserializers), Map.copyOf(this.serializers));
        }
    }

    static final class Builder
    implements NBT.Builder {
        private final SerializationRegistry registry = new SerializationRegistry();
        private boolean prettyPrinting = false;
        private int indents = 4;

        Builder() {
        }

        @Override
        public <T> NBT.Builder registerTypeHierarchyAdapter(Class<?> type, TagAdapter<T> adapter) {
            this.registry.registerTypeHierarchyAdapter(type, adapter);
            return this;
        }

        @Override
        public <T> NBT.Builder registerTypeHierarchyAdapter(Class<?> type, TagDeserializer<T> deserializer) {
            this.registry.registerTypeHierarchyAdapter(type, deserializer);
            return this;
        }

        @Override
        public <T> NBT.Builder registerTypeHierarchyAdapter(Class<?> type, TagSerializer<T> serializer) {
            this.registry.registerTypeHierarchyAdapter(type, serializer);
            return this;
        }

        @Override
        public <T> NBT.Builder registerTypeAdapter(Type type, TagAdapter<T> adapter) {
            this.registry.registerTypeAdapter(type, adapter);
            return this;
        }

        @Override
        public <T> NBT.Builder registerTypeAdapter(Type type, TagDeserializer<T> deserializer) {
            this.registry.registerTypeAdapter(type, deserializer);
            return this;
        }

        @Override
        public <T> NBT.Builder registerTypeAdapter(Type type, TagSerializer<T> serializer) {
            this.registry.registerTypeAdapter(type, serializer);
            return this;
        }

        @Override
        public NBT.Builder setPrettyPrinting(boolean prettyPrinting) {
            this.prettyPrinting = prettyPrinting;
            return this;
        }

        @Override
        public NBT.Builder setIndents(int indents) {
            this.indents = indents;
            return this;
        }

        @Override
        public NBT build() {
            return new SimpleNBT(this.registry.immutableCopy(), this.prettyPrinting, this.indents);
        }
    }
}

