/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.view;

import io.papermc.paper.FeatureHooks;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.thenextlvl.worlds.WorldsPlugin;
import net.thenextlvl.worlds.view.PaperLevelView;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.event.world.WorldUnloadEvent;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class FoliaLevelView
extends PaperLevelView {
    public FoliaLevelView(WorldsPlugin plugin) {
        super(plugin);
    }

    @Override
    public CompletableFuture<Void> saveAsync(World world, boolean flush) {
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        ServerLevel level = ((CraftWorld)world).getHandle();
        futures.add(this.saveLevelDataAsync(world));
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    @Override
    public CompletableFuture<Boolean> unloadAsync(World world, boolean save) {
        ServerLevel handle = ((CraftWorld)world).getHandle();
        CraftServer server = (CraftServer)this.plugin.getServer();
        if (server.getServer().getLevel(handle.dimension()) == null) {
            return CompletableFuture.completedFuture(false);
        }
        if (handle.dimension() == Level.OVERWORLD) {
            return CompletableFuture.completedFuture(false);
        }
        if (!handle.players().isEmpty()) {
            return CompletableFuture.completedFuture(false);
        }
        return this.plugin.supplyGlobal(() -> CompletableFuture.completedFuture(new WorldUnloadEvent((World)handle.getWorld()).callEvent())).thenCompose(success -> {
            if (!success.booleanValue()) {
                return CompletableFuture.completedFuture(false);
            }
            CompletableFuture<Object> saving = save ? this.saveAsync(world, true) : CompletableFuture.completedFuture(null);
            return ((CompletableFuture)((CompletableFuture)saving.handle((result, throwable) -> {
                if (throwable != null) {
                    this.plugin.getComponentLogger().error("Error during world save", throwable);
                }
                return this.plugin.supplyGlobal(() -> {
                    try {
                        handle.getChunkSource().close(false);
                        FeatureHooks.closeEntityManager((ServerLevel)handle, (boolean)save);
                        handle.levelStorageAccess.close();
                    }
                    catch (Exception e) {
                        this.plugin.getComponentLogger().error("Failed to properly close world after saving", (Throwable)e);
                        WorldsPlugin.ERROR_TRACKER.trackError(e);
                    }
                    return CompletableFuture.completedFuture(null);
                });
            })).thenCompose(self -> self)).thenApply(ignored -> {
                try {
                    Field field = server.getClass().getDeclaredField("worlds");
                    field.trySetAccessible();
                    Map worlds = (Map)field.get(server);
                    worlds.remove(world.getName().toLowerCase(Locale.ROOT));
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    this.plugin.getComponentLogger().error("Failed to remove world from memory", (Throwable)e);
                    WorldsPlugin.ERROR_TRACKER.trackError(e);
                    return false;
                }
                server.getServer().removeLevel(handle);
                return true;
            });
        });
    }
}

