/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.command.backup;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.io.IOException;
import java.nio.file.Files;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.worlds.WorldsPlugin;
import net.thenextlvl.worlds.command.WorldCommand;
import net.thenextlvl.worlds.command.brigadier.BrigadierCommand;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class WorldBackupCreateCommand
extends BrigadierCommand {
    private WorldBackupCreateCommand(WorldsPlugin plugin) {
        super(plugin, "create", "worlds.command.backup.create");
    }

    public static ArgumentBuilder<CommandSourceStack, ?> create(WorldsPlugin plugin) {
        WorldBackupCreateCommand command = new WorldBackupCreateCommand(plugin);
        LiteralArgumentBuilder all = (LiteralArgumentBuilder)Commands.literal((String)"*").executes(command::backupAll);
        RequiredArgumentBuilder world = (RequiredArgumentBuilder)WorldCommand.worldArgument(plugin).executes(command::backup);
        RequiredArgumentBuilder named = (RequiredArgumentBuilder)Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(command::backup);
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)command.create().then((ArgumentBuilder)all)).then(world.then((ArgumentBuilder)named))).executes(command::backup);
    }

    private int backupAll(CommandContext<CommandSourceStack> context) {
        return this.plugin.getServer().getWorlds().stream().mapToInt(world -> this.backup(context, (World)world, null)).sum();
    }

    private int backup(CommandContext<CommandSourceStack> context) {
        World world = this.tryGetArgument(context, "world", World.class).orElseGet(() -> ((CommandSourceStack)context.getSource()).getLocation().getWorld());
        String name = this.tryGetArgument(context, "name", String.class).orElse(null);
        return this.backup(context, world, name);
    }

    private int backup(CommandContext<CommandSourceStack> context, World world, @Nullable String name) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        TagResolver.Single placeholder = Placeholder.parsed((String)"world", (String)world.getName());
        this.plugin.bundle().sendMessage((Audience)sender, "world.backup", new TagResolver[]{placeholder});
        ((CompletableFuture)((CompletableFuture)this.plugin.levelView().createBackupAsync(world, name).thenApply(path -> {
            try {
                return Files.size(path);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to calculate backup size for " + String.valueOf(path), e);
            }
        })).thenAccept(bytes -> {
            double kb = (double)bytes.longValue() / 1024.0;
            double mb = kb / 1024.0;
            double gb = mb / 1024.0;
            this.plugin.bundle().sendMessage((Audience)sender, "world.backup.success", new TagResolver[]{placeholder, Formatter.number((String)"size", (Number)(gb >= 1.0 ? gb : (mb >= 1.0 ? mb : (kb >= 1.0 ? kb : (double)bytes.longValue())))), Formatter.choice((String)"unit", (Number)(gb >= 1.0 ? 0 : (mb >= 1.0 ? 1 : (kb >= 1.0 ? 2 : 3))))});
        })).exceptionally(throwable -> {
            this.plugin.getComponentLogger().warn("Failed to backup world {}", (Object)world.getName(), throwable);
            this.plugin.bundle().sendMessage((Audience)sender, "world.backup.failed", new TagResolver[]{placeholder});
            return null;
        });
        return 1;
    }
}

