/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.level;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.util.TriState;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.nbt.tag.Tag;
import net.thenextlvl.worlds.WorldsPlugin;
import net.thenextlvl.worlds.api.generator.Generator;
import net.thenextlvl.worlds.api.generator.GeneratorType;
import net.thenextlvl.worlds.api.generator.LevelStem;
import net.thenextlvl.worlds.api.level.Level;
import net.thenextlvl.worlds.api.preset.Biome;
import net.thenextlvl.worlds.api.preset.Layer;
import net.thenextlvl.worlds.api.preset.Preset;
import net.thenextlvl.worlds.api.preset.Structure;
import net.thenextlvl.worlds.level.PaperLevel;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.intellij.lang.annotations.Subst;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public abstract class LevelData
implements Level {
    protected final WorldsPlugin plugin;
    protected final Path directory;
    protected final Key key;
    protected final String name;
    protected final LevelStem levelStem;
    protected final GeneratorType generatorType;
    protected final @Nullable ChunkGenerator chunkGenerator;
    protected final @Nullable BiomeProvider biomeProvider;
    protected final @Nullable Generator generator;
    protected final @Nullable Preset preset;
    protected final TriState enabled;
    protected final boolean hardcore;
    protected final boolean worldKnown;
    protected final boolean structures;
    protected final boolean bonusChest;
    protected final boolean ignoreLevelData;
    protected final long seed;

    protected LevelData(WorldsPlugin plugin, Builder builder) {
        this.plugin = plugin;
        this.directory = builder.directory;
        this.name = builder.name != null ? builder.name : this.directory.getFileName().toString();
        this.key = builder.key != null ? builder.key : Key.key((String)"worlds", (String)LevelData.createKey(this.name));
        LevelStem levelStem = this.levelStem = builder.levelStem != null ? builder.levelStem : LevelData.getLevelStem(plugin, this.directory);
        GeneratorType generatorType = builder.generatorType != null ? builder.generatorType : (this.generatorType = builder.preset != null ? GeneratorType.FLAT : GeneratorType.NORMAL);
        Object object = builder.biomeProvider != null ? builder.biomeProvider : (this.biomeProvider = builder.generator != null ? builder.generator.biomeProvider(this.name) : null);
        this.chunkGenerator = builder.chunkGenerator != null ? builder.chunkGenerator : (builder.generator != null ? builder.generator.generator(this.name) : null);
        this.generator = builder.generator;
        this.preset = builder.preset;
        this.enabled = builder.enabled;
        this.hardcore = builder.hardcore != null ? builder.hardcore.booleanValue() : plugin.getServer().isHardcore();
        this.worldKnown = builder.worldKnown != null ? builder.worldKnown : false;
        this.structures = builder.structures != null ? builder.structures.booleanValue() : plugin.getServer().getGenerateStructures();
        this.bonusChest = builder.bonusChest != null ? builder.bonusChest : false;
        this.ignoreLevelData = builder.ignoreLevelData != null ? builder.ignoreLevelData : false;
        this.seed = builder.seed != null ? builder.seed.longValue() : ThreadLocalRandom.current().nextLong();
    }

    public Key key() {
        return this.key;
    }

    @Override
    public Path getDirectory() {
        return this.directory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public GeneratorType getGeneratorType() {
        return this.generatorType;
    }

    @Override
    public LevelStem getLevelStem() {
        return this.levelStem;
    }

    @Override
    public Optional<Preset> getPreset() {
        return Optional.ofNullable(this.preset);
    }

    @Override
    public Optional<BiomeProvider> getBiomeProvider() {
        return Optional.ofNullable(this.biomeProvider);
    }

    @Override
    public Optional<ChunkGenerator> getChunkGenerator() {
        return Optional.ofNullable(this.chunkGenerator);
    }

    @Override
    public Optional<Generator> getGenerator() {
        return Optional.ofNullable(this.generator);
    }

    @Override
    public TriState isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isWorldKnown() {
        return this.worldKnown;
    }

    @Override
    public boolean isHardcore() {
        return this.hardcore;
    }

    @Override
    public boolean hasStructures() {
        return this.structures;
    }

    @Override
    public boolean hasBonusChest() {
        return this.bonusChest;
    }

    @Override
    public boolean ignoreLevelData() {
        return this.ignoreLevelData;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public Level.Builder toBuilder() {
        return new Builder(this.plugin, this.directory).key(this.key).name(this.name).levelStem(this.levelStem).generatorType(this.generatorType).biomeProvider(this.biomeProvider).chunkGenerator(this.chunkGenerator).generator(this.generator).preset(this.preset).enabled(this.enabled).hardcore(this.hardcore).worldKnown(this.worldKnown).structures(this.structures).bonusChest(this.bonusChest).seed(this.seed);
    }

    public String toString() {
        return "LevelData{directory=" + String.valueOf(this.directory) + ", key=" + String.valueOf(this.key) + ", name='" + this.name + "', levelStem=" + String.valueOf(this.levelStem) + ", generatorType=" + String.valueOf(this.generatorType.key()) + ", generator=" + String.valueOf(this.generator) + ", preset=" + String.valueOf(this.preset) + ", enabled=" + String.valueOf(this.enabled) + ", hardcore=" + this.hardcore + ", worldKnown=" + this.worldKnown + ", structures=" + this.structures + ", bonusChest=" + this.bonusChest + ", seed=" + this.seed + "}";
    }

    public static Optional<Level.Builder> read(WorldsPlugin plugin, Path directory) throws IOException {
        Path container = plugin.getServer().getWorldContainer().toPath();
        Path level = directory.startsWith(container) ? directory : container.resolve(directory);
        CompoundTag levelData = plugin.levelView().getLevelDataFile(level);
        if (levelData == null) {
            return Optional.empty();
        }
        Optional<CompoundTag> data = levelData.optional("Data");
        String name = data.flatMap(tag -> tag.optional("LevelName").map(Tag::getAsString)).orElseGet(() -> level.getFileName().toString());
        Optional<Boolean> pdc = data.flatMap(tag -> tag.optional("BukkitValues").map(Tag::getAsCompound));
        Boolean worldKnown = pdc.map(LevelData::isKnown).orElse(false);
        Key key = pdc.flatMap(tag -> tag.optional("worlds:world_key").map(Tag::getAsString).map(Key::key)).orElseGet(() -> Key.key((String)"worlds", (String)LevelData.createKey(name)));
        LevelStem levelStem = pdc.flatMap(tag -> tag.optional("worlds:dimension").map(Tag::getAsString)).map(Key::key).map(LevelStem::of).orElseGet(() -> LevelData.getLevelStem(plugin, level));
        TriState enabled = pdc.flatMap(tag -> tag.optional("worlds:enabled").map(Tag::getAsBoolean).map(TriState::byBoolean)).orElse(TriState.NOT_SET);
        Generator chunkGenerator = pdc.flatMap(tag -> tag.optional("worlds:generator").map(Tag::getAsString)).map(serialized -> Generator.of(plugin, serialized)).orElse(null);
        Optional settings = data.flatMap(tag -> tag.optional("WorldGenSettings"));
        Optional dimensions = settings.flatMap(tag -> tag.optional("dimensions"));
        Optional dimension = dimensions.flatMap(tag -> tag.optional(levelStem.dimensionType().key().asString()));
        Optional generator = dimension.flatMap(tag -> tag.optional("generator"));
        Boolean hardcore = settings.flatMap(tag -> tag.optional("hardcore")).map(Tag::getAsBoolean).orElse(plugin.getServer().isHardcore());
        Long seed = settings.flatMap(tag -> tag.optional("seed")).map(Tag::getAsLong).orElse(ThreadLocalRandom.current().nextLong());
        Boolean structures = settings.flatMap(tag -> tag.optional("generate_features")).map(Tag::getAsBoolean).orElse(plugin.getServer().getGenerateStructures());
        Boolean bonusChest = settings.flatMap(tag -> tag.optional("bonus_chest")).map(Tag::getAsBoolean).orElse(false);
        Optional worldPreset = generator.flatMap(LevelData::getWorldPreset);
        Preset preset = worldPreset.filter(type -> type.equals(GeneratorType.FLAT)).flatMap(worldType -> generator.flatMap(LevelData::getFlatPreset)).orElse(null);
        GeneratorType generatorType = worldPreset.orElse(GeneratorType.NORMAL);
        return Optional.of(new Builder(plugin, level).key(key).name(name).levelStem(levelStem).generatorType(generatorType).generator(chunkGenerator).preset(preset).enabled(enabled).hardcore(hardcore).structures(structures).bonusChest(bonusChest).worldKnown(worldKnown).seed(seed));
    }

    private static Optional<Preset> getFlatPreset(CompoundTag generator) {
        Optional<CompoundTag> settings = generator.optional("settings");
        if (settings.isEmpty()) {
            return Optional.empty();
        }
        Preset preset = new Preset(null);
        settings.flatMap(tag -> tag.optional("biome")).map(Tag::getAsString).map(Biome::literal).ifPresent(preset::biome);
        settings.flatMap(tag -> tag.optional("features")).map(Tag::getAsBoolean).ifPresent(preset::features);
        settings.flatMap(tag -> tag.optional("lakes")).map(Tag::getAsBoolean).ifPresent(preset::lakes);
        settings.flatMap(tag -> tag.optional("layers")).map(tag -> tag.stream().map(layer -> {
            String block = ((Tag)layer.optional("block").orElseThrow()).getAsString();
            int height = ((Tag)layer.optional("height").orElseThrow()).getAsInt();
            return new Layer(block, height);
        }).collect(Collectors.toCollection(LinkedHashSet::new))).ifPresent(preset::layers);
        settings.flatMap(tag -> tag.optional("structure_overrides").filter(Tag::isList).map(Tag::getAsList)).map(list -> list.stream().map(Tag::getAsString).map(Structure::new).collect(Collectors.toCollection(LinkedHashSet::new))).ifPresent(preset::structures);
        settings.flatMap(tag -> tag.optional("structure_overrides").filter(Tag::isString).map(Tag::getAsString)).map(Structure::new).ifPresent(preset::addStructure);
        return Optional.of(preset);
    }

    private static Optional<GeneratorType> getWorldPreset(CompoundTag generator) {
        Optional<String> settings = generator.optional("settings").filter(Tag::isString).map(Tag::getAsString);
        if (settings.filter(s -> s.equals(GeneratorType.LARGE_BIOMES.key().asString())).isPresent()) {
            return Optional.of(GeneratorType.LARGE_BIOMES);
        }
        if (settings.filter(s -> s.equals(GeneratorType.AMPLIFIED.key().asString())).isPresent()) {
            return Optional.of(GeneratorType.AMPLIFIED);
        }
        Optional<String> generatorType = generator.optional("type").map(Tag::getAsString);
        if (generatorType.filter(s -> s.equals(GeneratorType.DEBUG.key().asString())).isPresent()) {
            return Optional.of(GeneratorType.DEBUG);
        }
        if (generatorType.filter(s -> s.equals(GeneratorType.FLAT.key().asString())).isPresent()) {
            return Optional.of(GeneratorType.FLAT);
        }
        if (generatorType.filter(s -> s.equals(GeneratorType.NORMAL.key().asString())).isPresent()) {
            return Optional.of(GeneratorType.NORMAL);
        }
        return Optional.empty();
    }

    private static LevelStem getLevelStem(WorldsPlugin plugin, Path directory) {
        if (Files.isDirectory(directory.resolve("region"), new LinkOption[0])) {
            return LevelStem.OVERWORLD;
        }
        boolean end = plugin.levelView().hasEndDimension(directory);
        boolean nether = plugin.levelView().hasNetherDimension(directory);
        if (end && !nether) {
            return LevelStem.END;
        }
        if (nether && !end) {
            return LevelStem.NETHER;
        }
        return LevelStem.OVERWORLD;
    }

    private static boolean isKnown(CompoundTag tag) {
        return tag.containsKey("worlds:dimension") || tag.containsKey("worlds:enabled") || tag.containsKey("worlds:generator") || tag.containsKey("worlds:world_key");
    }

    @Subst(value="pattern")
    public static String createKey(String name) {
        return name.toLowerCase().replaceAll("[^a-z0-9_\\-./ ]+", "").replace(" ", "_");
    }

    public static class Builder
    implements Level.Builder {
        private final WorldsPlugin plugin;
        private @Nullable Boolean bonusChest;
        private @Nullable Boolean hardcore;
        private @Nullable Boolean structures;
        private @Nullable Boolean worldKnown;
        private @Nullable Boolean ignoreLevelData;
        private @Nullable BiomeProvider biomeProvider;
        private @Nullable ChunkGenerator chunkGenerator;
        private @Nullable Generator generator;
        private @Nullable GeneratorType generatorType;
        private @Nullable Key key;
        private @Nullable LevelStem levelStem;
        private @Nullable Long seed;
        private @Nullable Preset preset;
        private @Nullable String name;
        private Path directory;
        private TriState enabled = TriState.NOT_SET;

        public Builder(WorldsPlugin plugin, Path directory) {
            this.plugin = plugin;
            this.directory = this.validate(directory);
        }

        private Path validate(Path directory) {
            Path container = this.plugin.getServer().getWorldContainer().toPath();
            return directory.startsWith(container) ? directory : container.resolve(directory);
        }

        @Override
        public Path directory() {
            return this.directory;
        }

        @Override
        public Level.Builder directory(Path directory) {
            this.directory = this.validate(directory);
            return this;
        }

        @Override
        public @Nullable Key key() {
            return this.key;
        }

        @Override
        public Level.Builder key(@Nullable Key key) {
            this.key = key;
            return this;
        }

        @Override
        public @Nullable String name() {
            return this.name;
        }

        @Override
        public Level.Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @Override
        public @Nullable BiomeProvider biomeProvider() {
            return this.biomeProvider;
        }

        @Override
        public Level.Builder biomeProvider(@Nullable BiomeProvider provider) {
            this.biomeProvider = provider;
            return this;
        }

        @Override
        public @Nullable ChunkGenerator chunkGenerator() {
            return this.chunkGenerator;
        }

        @Override
        public Level.Builder chunkGenerator(@Nullable ChunkGenerator generator) {
            this.chunkGenerator = generator;
            return this;
        }

        @Override
        public @Nullable LevelStem levelStem() {
            return this.levelStem;
        }

        @Override
        public Level.Builder levelStem(@Nullable LevelStem levelStem) {
            this.levelStem = levelStem;
            return this;
        }

        @Override
        public @Nullable GeneratorType generatorType() {
            return this.generatorType;
        }

        @Override
        public Level.Builder generatorType(@Nullable GeneratorType type) {
            this.generatorType = type;
            return this;
        }

        @Override
        public @Nullable Boolean ignoreLevelData() {
            return this.ignoreLevelData;
        }

        @Override
        public Level.Builder ignoreLevelData(@Nullable Boolean ignoreLevelData) {
            this.ignoreLevelData = ignoreLevelData;
            return this;
        }

        @Override
        public @Nullable Generator generator() {
            return this.generator;
        }

        @Override
        public Level.Builder generator(@Nullable Generator generator) {
            this.generator = generator;
            return this;
        }

        @Override
        public @Nullable Preset preset() {
            return this.preset;
        }

        @Override
        public Level.Builder preset(@Nullable Preset preset) {
            this.preset = preset;
            return this;
        }

        @Override
        public TriState enabled() {
            return this.enabled;
        }

        @Override
        public Level.Builder enabled(TriState enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public @Nullable Boolean hardcore() {
            return this.hardcore;
        }

        @Override
        public Level.Builder hardcore(@Nullable Boolean hardcore) {
            this.hardcore = hardcore;
            return this;
        }

        @Override
        public @Nullable Boolean structures() {
            return this.structures;
        }

        @Override
        public Level.Builder structures(@Nullable Boolean structures) {
            this.structures = structures;
            return this;
        }

        @Override
        public @Nullable Boolean bonusChest() {
            return this.bonusChest;
        }

        @Override
        public Level.Builder bonusChest(@Nullable Boolean bonusChest) {
            this.bonusChest = bonusChest;
            return this;
        }

        @Override
        public @Nullable Boolean worldKnown() {
            return this.worldKnown;
        }

        @Override
        public Level.Builder worldKnown(@Nullable Boolean worldKnown) {
            this.worldKnown = worldKnown;
            return this;
        }

        @Override
        public @Nullable Long seed() {
            return this.seed;
        }

        @Override
        public Level.Builder seed(@Nullable Long seed) {
            this.seed = seed;
            return this;
        }

        @Override
        public Level build() {
            return new PaperLevel(this.plugin, this);
        }
    }
}

