/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.command.argument;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.thenextlvl.worlds.WorldsPlugin;
import net.thenextlvl.worlds.api.preset.Preset;
import net.thenextlvl.worlds.api.preset.Presets;
import net.thenextlvl.worlds.command.argument.SimpleArgumentType;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class WorldPresetArgument
implements SimpleArgumentType<Preset, String> {
    private static final Map<String, Preset> identifiers = Presets.presets().stream().filter(preset -> preset.name() != null).collect(Collectors.toMap(preset -> WorldPresetArgument.toIdentifier(Objects.requireNonNull(preset.name(), "Preset name cannot be null")), preset -> preset));
    private final WorldsPlugin plugin;

    public WorldPresetArgument(WorldsPlugin plugin) {
        this.plugin = plugin;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Preset convert(StringReader reader, String type) {
        Preset optional = identifiers.get(WorldPresetArgument.toIdentifier(type));
        if (optional != null) {
            return optional;
        }
        Path file = this.plugin.presetsFolder().resolve(type + ".json");
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            throw new IllegalStateException("No preset found");
        }
        try (JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader((InputStream)new BufferedInputStream(Files.newInputStream(file, new OpenOption[0])), StandardCharsets.UTF_8));){
            JsonElement root = JsonParser.parseReader((JsonReader)jsonReader);
            if (!root.isJsonObject()) throw new IllegalStateException("Not a valid preset");
            Preset preset = Preset.deserialize(root.getAsJsonObject());
            return preset;
        }
        catch (IOException e) {
            throw new IllegalStateException("Not a valid preset", e);
        }
    }

    public ArgumentType<String> getNativeType() {
        return StringArgumentType.string();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return ((CompletableFuture)CompletableFuture.runAsync(() -> {
            HashSet<String> presets = new HashSet<String>(identifiers.keySet());
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.plugin.presetsFolder(), "*.json");){
                for (Path path : directoryStream) {
                    String fileName = path.getFileName().toString();
                    String suggestion = fileName.substring(0, fileName.length() - 5);
                    presets.add(suggestion);
                }
            }
            catch (IOException e) {
                this.plugin.getComponentLogger().warn("Failed to read presets from disk", (Throwable)e);
            }
            presets.stream().filter(s -> s.toLowerCase(Locale.ROOT).contains(builder.getRemainingLowerCase())).map(StringArgumentType::escapeIfRequired).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        }).exceptionally(throwable -> {
            this.plugin.getComponentLogger().error("Failed to list presets", throwable);
            return null;
        })).thenApply(ignored -> builder.build());
    }

    private static String toIdentifier(String name) {
        return name.toLowerCase(Locale.ROOT).replace(" ", "-").replace("'", "");
    }
}

