/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.api.level;

import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.util.TriState;
import net.thenextlvl.worlds.api.generator.Generator;
import net.thenextlvl.worlds.api.generator.GeneratorType;
import net.thenextlvl.worlds.api.generator.LevelStem;
import net.thenextlvl.worlds.api.preset.Preset;
import org.bukkit.World;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@ApiStatus.NonExtendable
public interface Level
extends Keyed {
    @Contract(pure=true)
    public Path getDirectory();

    @Contract(pure=true)
    public String getName();

    @Contract(pure=true)
    public Optional<Preset> getPreset();

    @Contract(pure=true)
    public Optional<BiomeProvider> getBiomeProvider();

    @Contract(pure=true)
    public Optional<ChunkGenerator> getChunkGenerator();

    @Contract(pure=true)
    public Optional<Generator> getGenerator();

    @Contract(pure=true)
    public boolean isHardcore();

    @Contract(pure=true)
    public boolean hasStructures();

    @Contract(pure=true)
    public boolean hasBonusChest();

    @Deprecated(forRemoval=true, since="3.3.1")
    @Contract(pure=true)
    default public int getSpawnChunkRadius() {
        return 0;
    }

    @Contract(pure=true)
    public long getSeed();

    @Contract(pure=true)
    @ApiStatus.Experimental
    public GeneratorType getGeneratorType();

    @Contract(pure=true)
    @ApiStatus.Experimental
    public LevelStem getLevelStem();

    @ApiStatus.Internal
    @Contract(pure=true)
    public TriState isEnabled();

    @ApiStatus.Internal
    @Contract(pure=true)
    public boolean isWorldKnown();

    @ApiStatus.Internal
    @Contract(pure=true)
    public boolean ignoreLevelData();

    @Contract(pure=true)
    public Builder toBuilder();

    @Deprecated(forRemoval=true, since="3.2.0")
    @Contract(mutates="io")
    default public Optional<World> create() {
        return Optional.of(this.createAsync().join());
    }

    @Contract(mutates="io")
    public CompletableFuture<World> createAsync();

    public static interface Builder {
        @Contract(pure=true)
        public Path directory();

        @Contract(mutates="this")
        public Builder directory(Path var1);

        @Contract(pure=true)
        public @Nullable Key key();

        @Contract(mutates="this")
        public Builder key(@Nullable Key var1);

        @Contract(pure=true)
        public @Nullable String name();

        @Contract(mutates="this")
        public Builder name(@Nullable String var1);

        @Contract(pure=true)
        public @Nullable BiomeProvider biomeProvider();

        @Contract(mutates="this")
        public Builder biomeProvider(@Nullable BiomeProvider var1);

        @Contract(pure=true)
        public @Nullable ChunkGenerator chunkGenerator();

        @Contract(mutates="this")
        public Builder chunkGenerator(@Nullable ChunkGenerator var1);

        @Contract(pure=true)
        public @Nullable Generator generator();

        @Contract(mutates="this")
        public Builder generator(@Nullable Generator var1);

        @Contract(pure=true)
        public @Nullable Preset preset();

        @Contract(mutates="this")
        public Builder preset(@Nullable Preset var1);

        @Contract(pure=true)
        public @Nullable Boolean hardcore();

        @Contract(mutates="this")
        public Builder hardcore(@Nullable Boolean var1);

        @Contract(pure=true)
        public @Nullable Boolean structures();

        @Contract(mutates="this")
        public Builder structures(@Nullable Boolean var1);

        @Contract(pure=true)
        public @Nullable Boolean bonusChest();

        @Contract(mutates="this")
        public Builder bonusChest(@Nullable Boolean var1);

        @Deprecated(forRemoval=true, since="3.3.1")
        @Contract(pure=true)
        default public @Nullable Integer spawnChunkRadius() {
            return 0;
        }

        @Deprecated(forRemoval=true, since="3.3.1")
        @Contract(mutates="this")
        default public Builder spawnChunkRadius(@Nullable Integer radius) {
            return this;
        }

        @Contract(pure=true)
        public @Nullable Long seed();

        @Contract(mutates="this")
        public Builder seed(@Nullable Long var1);

        @Contract(pure=true)
        public Level build();

        @Contract(pure=true)
        @ApiStatus.Experimental
        public @Nullable LevelStem levelStem();

        @ApiStatus.Experimental
        @Contract(mutates="this")
        public Builder levelStem(@Nullable LevelStem var1);

        @Contract(pure=true)
        @ApiStatus.Experimental
        public @Nullable GeneratorType generatorType();

        @ApiStatus.Experimental
        @Contract(mutates="this")
        public Builder generatorType(@Nullable GeneratorType var1);

        @ApiStatus.Internal
        @Contract(pure=true)
        public @Nullable Boolean ignoreLevelData();

        @ApiStatus.Internal
        @Contract(mutates="this")
        public Builder ignoreLevelData(@Nullable Boolean var1);

        @ApiStatus.Internal
        @Contract(pure=true)
        public @Nullable Boolean worldKnown();

        @ApiStatus.Internal
        @Contract(mutates="this")
        public Builder worldKnown(@Nullable Boolean var1);

        @ApiStatus.Internal
        @Contract(pure=true)
        public TriState enabled();

        @ApiStatus.Internal
        @Contract(mutates="this")
        public Builder enabled(TriState var1);
    }
}

