/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.worlds.WorldsPlugin;
import net.thenextlvl.worlds.api.generator.Generator;
import net.thenextlvl.worlds.api.generator.GeneratorType;
import net.thenextlvl.worlds.api.generator.LevelStem;
import net.thenextlvl.worlds.api.level.Level;
import net.thenextlvl.worlds.api.preset.Preset;
import net.thenextlvl.worlds.command.argument.GeneratorArgument;
import net.thenextlvl.worlds.command.argument.KeyArgument;
import net.thenextlvl.worlds.command.argument.LevelPathArgument;
import net.thenextlvl.worlds.command.argument.LevelStemArgument;
import net.thenextlvl.worlds.command.argument.WorldPresetArgument;
import net.thenextlvl.worlds.command.brigadier.OptionCommand;
import net.thenextlvl.worlds.command.suggestion.LevelSuggestionProvider;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class WorldImportCommand
extends OptionCommand {
    private WorldImportCommand(WorldsPlugin plugin) {
        super(plugin, "import", "worlds.command.import");
    }

    public static ArgumentBuilder<CommandSourceStack, ?> create(WorldsPlugin plugin) {
        WorldImportCommand command = new WorldImportCommand(plugin);
        return command.create().then(command.createCommand());
    }

    protected RequiredArgumentBuilder<CommandSourceStack, Path> createCommand() {
        RequiredArgumentBuilder command = (RequiredArgumentBuilder)Commands.argument((String)"path", (ArgumentType)new LevelPathArgument(this.plugin)).suggests((SuggestionProvider)new LevelSuggestionProvider(this.plugin, true)).executes((Command)this);
        this.addOptions((ArgumentBuilder<CommandSourceStack, ?>)command, false, Set.of(new OptionCommand.Option("dimension", (ArgumentType<?>)new LevelStemArgument(this.plugin)), new OptionCommand.Option("directory", (ArgumentType<?>)new LevelPathArgument(this.plugin)), new OptionCommand.Option("generator", (ArgumentType<?>)new GeneratorArgument(this.plugin), "preset"), new OptionCommand.Option("key", (ArgumentType<?>)new KeyArgument()), new OptionCommand.Option("name", (ArgumentType<?>)StringArgumentType.string()), new OptionCommand.Option("preset", (ArgumentType<?>)new WorldPresetArgument(this.plugin), "generator")), null);
        return command;
    }

    public int run(CommandContext<CommandSourceStack> context) {
        Optional<Level> build;
        CompletableFuture world;
        Path container;
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        Path path = (Path)context.getArgument("path", Path.class);
        if (!path.startsWith(container = this.plugin.levelView().getWorldContainer()) || path.getNameCount() != container.getNameCount() + 1) {
            this.plugin.bundle().sendMessage((Audience)sender, "world.container.load");
            return 0;
        }
        Preset preset = this.tryGetArgument(context, "preset", Preset.class).orElse(null);
        LevelStem dimension = this.tryGetArgument(context, "dimension", LevelStem.class).orElse(null);
        Path directory = this.tryGetArgument(context, "directory", Path.class).filter(dir -> !dir.equals(path)).orElse(null);
        String displayName = this.tryGetArgument(context, "name", String.class).orElse(null);
        Generator generator = this.tryGetArgument(context, "generator", Generator.class).orElse(null);
        Key key = this.tryGetArgument(context, "key", Key.class).orElse(null);
        String name = displayName != null ? displayName : path.getFileName().toString();
        this.plugin.bundle().sendMessage((Audience)sender, "world.import", new TagResolver[]{Placeholder.parsed((String)"world", (String)name)});
        if (directory != null) {
            try {
                this.plugin.levelView().copyDirectory(path, directory, null);
            }
            catch (IOException e) {
                this.plugin.getComponentLogger().warn("Failed to copy world {} to {}", new Object[]{path, directory, e});
                this.plugin.bundle().sendMessage((Audience)sender, "world.import.failed", new TagResolver[]{Placeholder.parsed((String)"world", (String)name)});
                return 0;
            }
        }
        if ((world = (CompletableFuture)(build = this.plugin.levelView().read(path).map(level -> {
            if (directory != null) {
                level.directory(directory).worldKnown(false);
            }
            if (preset != null) {
                level.generatorType(GeneratorType.FLAT).ignoreLevelData(true).preset(preset);
            }
            return level.key(key).generator(generator).levelStem(dimension).name(displayName).build();
        })).filter(level -> !level.isWorldKnown()).map(Level::createAsync).orElse(null)) == null) {
            this.plugin.bundle().sendMessage((Audience)sender, "world.import.failed", new TagResolver[]{Placeholder.parsed((String)"world", (String)name)});
            return 0;
        }
        ((CompletableFuture)world.thenAccept(level -> {
            this.plugin.bundle().sendMessage((Audience)sender, "world.import.success", new TagResolver[]{Placeholder.parsed((String)"world", (String)level.getName())});
            if (!(sender instanceof Entity)) {
                return;
            }
            Entity entity = (Entity)sender;
            entity.teleportAsync(level.getSpawnLocation(), PlayerTeleportEvent.TeleportCause.COMMAND);
        })).exceptionally(throwable -> {
            this.plugin.bundle().sendMessage((Audience)sender, "world.import.failed", new TagResolver[]{Placeholder.parsed((String)"world", (String)name)});
            Throwable t = throwable.getCause() != null ? throwable.getCause() : throwable;
            this.plugin.getComponentLogger().warn("Failed to import world {}", (Object)name, (Object)t);
            return null;
        });
        return 1;
    }
}

