/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.view;

import com.google.common.base.Preconditions;
import io.papermc.paper.plugin.provider.classloader.ConfiguredPluginClassLoader;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.KeyPattern;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FileUtil;
import net.minecraft.world.level.storage.WorldData;
import net.thenextlvl.nbt.NBTInputStream;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.worlds.WorldsPlugin;
import net.thenextlvl.worlds.api.event.WorldActionScheduledEvent;
import net.thenextlvl.worlds.api.event.WorldBackupEvent;
import net.thenextlvl.worlds.api.event.WorldBackupRestoreEvent;
import net.thenextlvl.worlds.api.event.WorldCloneEvent;
import net.thenextlvl.worlds.api.event.WorldDeleteEvent;
import net.thenextlvl.worlds.api.event.WorldRegenerateEvent;
import net.thenextlvl.worlds.api.exception.GeneratorException;
import net.thenextlvl.worlds.api.level.Level;
import net.thenextlvl.worlds.api.view.LevelView;
import net.thenextlvl.worlds.level.LevelData;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.boss.DragonBattle;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.generator.WorldInfo;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class PaperLevelView
implements LevelView {
    private static final Key OVERWORLD = Key.key((String)"overworld");
    private static final Key NETHER = Key.key((String)"the_nether");
    private static final Key END = Key.key((String)"the_end");
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss").withZone(ZoneId.systemDefault());
    private static final NamespacedKey ENABLED_KEY = new NamespacedKey("worlds", "enabled");
    private static final Set<String> SKIP_DIRECTORIES = Set.of("advancements", "datapacks", "playerdata", "stats");
    private static final Set<String> SKIP_FILES = Set.of("uid.dat", "session.lock");
    private final Map<Key, Runnable> backupRestorations = new ConcurrentHashMap<Key, Runnable>();
    private final Map<Key, Runnable> deletions = new ConcurrentHashMap<Key, Runnable>();
    private final Map<Key, Runnable> regenerations = new ConcurrentHashMap<Key, Runnable>();
    protected final WorldsPlugin plugin;

    public PaperLevelView(WorldsPlugin plugin) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            this.backupRestorations.values().forEach(Runnable::run);
            this.deletions.values().forEach(Runnable::run);
            this.regenerations.values().forEach(Runnable::run);
        }, "Worlds Shutdown Hook"));
        this.plugin = plugin;
    }

    public World getOverworld() {
        return this.getWorld(OVERWORLD).orElseThrow(() -> new IllegalStateException("Overworld not found"));
    }

    public Optional<World> getNether() {
        return this.getWorld(NETHER);
    }

    public Optional<World> getEnd() {
        return this.getWorld(END);
    }

    private Optional<World> getWorld(Key key) {
        return Optional.ofNullable(this.plugin.getServer().getWorld(key));
    }

    public boolean isOverworld(World world) {
        return world.key().equals((Object)OVERWORLD);
    }

    public boolean isEnd(World world) {
        return world.key().equals((Object)END);
    }

    private @Nullable Path getLevelDataPath(Path level) {
        return Optional.ofNullable(PaperLevelView.getFile(level, "level.dat")).orElseGet(() -> PaperLevelView.getFile(level, "level.dat_old"));
    }

    public @Nullable CompoundTag getLevelDataFile(Path level) throws IOException {
        Path path = this.getLevelDataPath(level);
        if (path == null) {
            return null;
        }
        try (NBTInputStream inputStream = NBTInputStream.create(path);){
            CompoundTag compoundTag = inputStream.readTag().getAsCompound();
            return compoundTag;
        }
    }

    private static @Nullable Path getFile(Path level, String other) {
        Path resolved = level.resolve(other);
        return Files.isRegularFile(resolved, new LinkOption[0]) ? resolved : null;
    }

    @Override
    public Path getBackupFolder() {
        String backupFolder = System.getenv("WORLDS_BACKUP_FOLDER");
        if (backupFolder == null) {
            backupFolder = System.getProperty("worlds.backup.folder");
        }
        if (backupFolder != null) {
            return Path.of(backupFolder, new String[0]);
        }
        Path parent = this.getWorldContainer().getParent();
        return parent != null ? parent.resolve("backups") : Path.of("backups", new String[0]);
    }

    @Override
    public Path getBackupFolder(World world) {
        return this.getBackupFolder().resolve(world.getName());
    }

    @Override
    public Path getWorldContainer() {
        return this.plugin.getServer().getWorldContainer().toPath();
    }

    @Override
    public String getEntryPermission(World world) {
        return "worlds.enter." + world.key().asString();
    }

    @Override
    public Optional<Level.Builder> read(Path directory) {
        try {
            return LevelData.read(this.plugin, directory);
        }
        catch (GeneratorException e) {
            String generator = e.getId() != null ? e.getPlugin() + ":" + e.getId() : e.getPlugin();
            this.plugin.getComponentLogger().error("Skip loading dimension '{}'", (Object)directory.getFileName());
            this.plugin.getComponentLogger().error("Cannot use generator {}: {}", (Object)generator, (Object)e.getMessage());
            return Optional.empty();
        }
        catch (Exception e) {
            if (e.getCause() instanceof ZipException) {
                this.plugin.getComponentLogger().warn("Failed to read level data from {}", (Object)directory);
                this.plugin.getComponentLogger().warn("Your level.dat is irrecoverably corrupted. Please delete it and recreate the world.");
            } else {
                this.plugin.getComponentLogger().warn("Failed to read level data from {}", (Object)directory, (Object)e);
            }
            return Optional.empty();
        }
    }

    @Override
    public Optional<JavaPlugin> getGenerator(World world) {
        return Optional.ofNullable(world.getGenerator()).map(chunkGenerator -> chunkGenerator.getClass().getClassLoader()).filter(ConfiguredPluginClassLoader.class::isInstance).map(ConfiguredPluginClassLoader.class::cast).map(ConfiguredPluginClassLoader::getPlugin);
    }

    @Override
    public @Unmodifiable Set<Path> listLevels() {
        return this.listDirectories().stream().filter(this::isLevel).collect(Collectors.toUnmodifiableSet());
    }

    private @Unmodifiable Set<Path> listDirectories() {
        Set<Path> set;
        block8: {
            Stream<Path> stream = Files.list(this.plugin.getServer().getWorldContainer().toPath());
            try {
                set = stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toUnmodifiableSet());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return Set.of();
                }
            }
            stream.close();
        }
        return set;
    }

    @Override
    public boolean canLoad(Path level) {
        return this.plugin.getServer().getWorlds().stream().map(World::getWorldFolder).map(File::toPath).noneMatch(level::equals);
    }

    @Override
    public boolean hasEndDimension(Path level) {
        return Files.isDirectory(level.resolve("DIM1"), new LinkOption[0]);
    }

    @Override
    public boolean hasNetherDimension(Path level) {
        return Files.isDirectory(level.resolve("DIM-1"), new LinkOption[0]);
    }

    @Override
    public boolean isLevel(Path path) {
        return Files.isRegularFile(path.resolve("level.dat"), new LinkOption[0]) || Files.isRegularFile(path.resolve("level.dat_old"), new LinkOption[0]);
    }

    @Override
    public CompletableFuture<Boolean> unloadAsync(World world, boolean save) {
        return ((CompletableFuture)this.saveLevelDataAsync(world).thenCompose(ignored -> this.plugin.supplyGlobal(() -> {
            DragonBattle dragonBattle = world.getEnderDragonBattle();
            if (!this.plugin.getServer().unloadWorld(world, save)) {
                return CompletableFuture.completedFuture(false);
            }
            if (dragonBattle != null) {
                dragonBattle.getBossBar().removeAll();
            }
            return CompletableFuture.completedFuture(true);
        }))).exceptionally(throwable -> {
            this.plugin.getComponentLogger().warn("Failed to save level data before unloading", throwable);
            return false;
        });
    }

    @Override
    public CompletableFuture<@Nullable Void> saveAsync(World world, boolean flush) {
        return this.plugin.supplyGlobal(() -> {
            try {
                ServerLevel level = ((CraftWorld)world).getHandle();
                boolean oldSave = level.noSave;
                level.noSave = false;
                level.save(null, flush, false);
                level.noSave = oldSave;
                return CompletableFuture.completedFuture(null);
            }
            catch (Exception e) {
                return CompletableFuture.failedFuture(e);
            }
        }).thenRun(() -> this.saveLevelDataAsync(world));
    }

    @Override
    public CompletableFuture<@Nullable Void> saveLevelDataAsync(World world) {
        ServerLevel level = ((CraftWorld)world).getHandle();
        if (level.getDragonFight() != null) {
            level.serverLevelData.setEndDragonFightData(level.getDragonFight().saveData());
        }
        level.serverLevelData.setCustomBossEvents(level.getServer().getCustomBossEvents().save((HolderLookup.Provider)level.registryAccess()));
        level.levelStorageAccess.saveDataTag((RegistryAccess)level.getServer().registryAccess(), (WorldData)level.serverLevelData, level.getServer().getPlayerList().getSingleplayerData());
        return level.getChunkSource().getDataStorage().scheduleSave().thenApply(ignored -> null);
    }

    @Override
    public boolean isEnabled(World world) {
        return Boolean.TRUE.equals(world.getPersistentDataContainer().get(ENABLED_KEY, PersistentDataType.BOOLEAN));
    }

    @Override
    public void setEnabled(World world, boolean enabled) {
        world.getPersistentDataContainer().set(ENABLED_KEY, PersistentDataType.BOOLEAN, (Object)enabled);
    }

    @Override
    public CompletableFuture<Path> createBackupAsync(World world, @Nullable String name) {
        return this.plugin.supplyGlobal(() -> {
            new WorldBackupEvent(world).callEvent();
            return this.saveAsync(world, true).thenComposeAsync(ignored -> {
                try {
                    return CompletableFuture.completedFuture(this.backupInternal(world, name));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(e);
                }
            });
        });
    }

    @Override
    public CompletableFuture<LevelView.RestoringResult> restoreBackupAsync(World world, Path backupFile, boolean schedule) {
        if (!Files.isRegularFile(backupFile, new LinkOption[0])) {
            return CompletableFuture.completedFuture(new RestoringResultImpl(null, LevelView.DeletionResult.FAILED));
        }
        return this.plugin.supplyGlobal(() -> {
            if (schedule) {
                return CompletableFuture.completedFuture(this.scheduleRestoreBackup(world, backupFile));
            }
            if (this.isOverworld(world)) {
                return CompletableFuture.completedFuture(new RestoringResultImpl(null, LevelView.DeletionResult.REQUIRES_SCHEDULING));
            }
            if (!new WorldBackupRestoreEvent(world, backupFile).callEvent()) {
                return CompletableFuture.completedFuture(new RestoringResultImpl(null, LevelView.DeletionResult.FAILED));
            }
            return this.restoreBackupInternal(world, backupFile);
        });
    }

    @Override
    public boolean cancelScheduledBackupRestoration(World world) {
        return this.backupRestorations.remove(world.key()) != null;
    }

    @Override
    public boolean isBackupRestorationScheduled(World world) {
        return this.backupRestorations.containsKey(world.key());
    }

    private LevelView.RestoringResult scheduleRestoreBackup(World world, Path backupFile) {
        LevelView.DeletionResult deletionResult = this.scheduleAction(world, WorldActionScheduledEvent.ActionType.RESTORE_BACKUP, this.backupRestorations, path -> this.restore((Path)path, backupFile));
        return new RestoringResultImpl(null, deletionResult);
    }

    private CompletableFuture<LevelView.RestoringResult> restoreBackupInternal(World world, Path path) {
        List players = world.getPlayers();
        Location fallback = this.getOverworld().getSpawnLocation();
        return CompletableFuture.allOf((CompletableFuture[])players.stream().map(player -> player.teleportAsync(fallback, PlayerTeleportEvent.TeleportCause.PLUGIN).thenAccept(success -> {
            if (!success.booleanValue()) {
                player.kick(this.plugin.bundle().component("world.unload.kicked", (Audience)player));
            }
        })).toArray(CompletableFuture[]::new)).thenCompose(ignored -> {
            Path worldPath = world.getWorldFolder().toPath();
            return ((CompletableFuture)this.unloadAsync(world, true).thenComposeAsync(success -> {
                if (!success.booleanValue()) {
                    return CompletableFuture.completedFuture(new RestoringResultImpl(null, LevelView.DeletionResult.UNLOAD_FAILED));
                }
                this.restore(worldPath, path);
                this.backupRestorations.remove(world.key());
                return this.plugin.levelView().read(worldPath).orElseThrow().build().createAsync().thenApply(restored -> {
                    players.forEach(player -> player.teleportAsync(restored.getSpawnLocation(), PlayerTeleportEvent.TeleportCause.PLUGIN));
                    return new RestoringResultImpl((World)restored, LevelView.DeletionResult.SUCCESS);
                });
            })).exceptionallyCompose(throwable -> {
                this.plugin.getComponentLogger().warn("Failed to restore backup", throwable);
                return this.plugin.levelBuilder(world).build().createAsync().thenApply(restored -> {
                    players.forEach(player -> player.teleportAsync(restored.getSpawnLocation(), PlayerTeleportEvent.TeleportCause.PLUGIN));
                    return new RestoringResultImpl(null, LevelView.DeletionResult.FAILED);
                });
            });
        });
    }

    private void restore(Path worldPath, Path path) {
        Path tempPath;
        while (Files.isDirectory(tempPath = worldPath.resolveSibling("." + String.valueOf(UUID.randomUUID())), new LinkOption[0])) {
        }
        try (ZipInputStream input = new ZipInputStream(Files.newInputStream(path, StandardOpenOption.READ));){
            ZipEntry entry;
            Path root = tempPath.toAbsolutePath().normalize();
            while ((entry = input.getNextEntry()) != null) {
                Path resolved;
                try {
                    resolved = PaperLevelView.resolveZipEntry(root, entry);
                }
                catch (IOException e) {
                    this.plugin.getComponentLogger().warn("Skipping suspicious zip entry: {}", (Object)entry.getName(), (Object)e);
                    continue;
                }
                if (entry.isDirectory()) {
                    Files.createDirectories(resolved, new FileAttribute[0]);
                    continue;
                }
                Path parent = resolved.getParent();
                if (parent != null) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                Files.copy(input, resolved, new CopyOption[0]);
            }
            Files.walkFileTree(worldPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, @Nullable IOException exc) throws IOException {
                    if (exc != null) {
                        throw exc;
                    }
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
            Files.move(tempPath, worldPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            try {
                Files.deleteIfExists(tempPath);
            }
            catch (IOException ex) {
                this.plugin.getComponentLogger().warn("Failed to delete temporary files for backup restoration", (Throwable)ex);
            }
            throw new RuntimeException("Failed to restore backup from " + String.valueOf(path) + " to " + String.valueOf(worldPath), e);
        }
    }

    private static Path resolveZipEntry(Path path, ZipEntry entry) throws IOException {
        Path target = path.resolve(entry.getName()).normalize();
        if (!target.startsWith(path)) {
            throw new IOException("Zip entry outside target dir: " + entry.getName());
        }
        return target;
    }

    @Override
    public Stream<Path> listBackups(World world) {
        try {
            Stream<Path> files = Files.list(this.getBackupFolder(world));
            return (Stream)files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().endsWith(".zip")).onClose(files::close);
        }
        catch (IOException ignored) {
            return Stream.empty();
        }
    }

    private Path backupInternal(final World world, @Nullable String name) throws IOException {
        Path backupPath = this.getBackupFolder(world);
        Files.createDirectories(backupPath, new FileAttribute[0]);
        String availableName = name != null ? name + ".zip" : FileUtil.findAvailableName((Path)backupPath, (String)FORMATTER.format(Instant.now()), (String)".zip");
        Path path = backupPath.resolve(availableName);
        if (name != null && Files.isRegularFile(path, new LinkOption[0])) {
            throw new FileAlreadyExistsException(path.toString(), null, "A Backup named " + name + " already exists for " + String.valueOf(world.key()));
        }
        try (final ZipOutputStream output = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(path, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE)));){
            Files.walkFileTree(world.getWorldFolder().toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (!file.endsWith("session.lock")) {
                        String relative = world.getWorldFolder().toPath().relativize(file).toString().replace('\\', '/');
                        output.putNextEntry(new ZipEntry(relative));
                        Files.copy(file, output);
                        output.closeEntry();
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return path;
    }

    public String findFreeName(String name) {
        Set<String> usedNames = this.plugin.getServer().getWorlds().stream().map(WorldInfo::getName).collect(Collectors.toSet());
        return PaperLevelView.findFreeName(usedNames, name);
    }

    public Key findFreeKey(Key key) {
        return this.findFreeKey(key.namespace(), key.value());
    }

    public Key findFreeKey(@KeyPattern.Namespace String namespace, @KeyPattern.Value String value) {
        Set<String> usedValues = this.plugin.getServer().getWorlds().stream().map(Keyed::key).filter(key -> key.namespace().equals(namespace)).map(Key::value).collect(Collectors.toSet());
        return Key.key((String)namespace, (String)PaperLevelView.findFreeValue(usedValues, value));
    }

    public Path findFreePath(String name) {
        Set<String> usedPaths = this.listDirectories().stream().map(Path::getFileName).map(Path::toString).collect(Collectors.toSet());
        return Path.of(PaperLevelView.findFreeName(usedPaths, name), new String[0]);
    }

    public static String findFreeName(Set<String> usedNames, String name) {
        if (!usedNames.contains(name)) {
            return name;
        }
        String baseName = name;
        int suffix = 1;
        String candidate = baseName + " (1)";
        Pattern pattern = Pattern.compile("^(.+) \\((\\d+)\\)$");
        Matcher matcher = pattern.matcher(name);
        if (matcher.matches()) {
            baseName = matcher.group(1);
            suffix = Integer.parseInt(matcher.group(2)) + 1;
            candidate = baseName + " (" + suffix + ")";
            ++suffix;
        }
        while (usedNames.contains(candidate)) {
            candidate = baseName + " (" + suffix++ + ")";
        }
        return candidate;
    }

    public static String findFreeValue(Set<String> usedValues, String value) {
        if (!usedValues.contains(value)) {
            return value;
        }
        String baseValue = value;
        int suffix = 1;
        String candidate = baseValue + "_1";
        Pattern pattern = Pattern.compile("^(.+) \\((\\d+)\\)$");
        Matcher matcher = pattern.matcher(value);
        if (matcher.matches()) {
            baseValue = matcher.group(1);
            suffix = Integer.parseInt(matcher.group(2)) + 1;
            candidate = baseValue + "_" + suffix;
            ++suffix;
        }
        while (usedValues.contains(candidate)) {
            candidate = baseValue + "_" + suffix++;
        }
        return candidate;
    }

    @Override
    public CompletableFuture<World> cloneAsync(World world, Consumer<Level.Builder> builder, boolean full) {
        return this.plugin.supplyGlobal(() -> this.cloneInternal(world, builder, full));
    }

    private CompletableFuture<World> cloneInternal(World world, Consumer<Level.Builder> builder, boolean full) {
        Level.Builder levelBuilder = this.plugin.levelBuilder(world);
        levelBuilder.name(this.findFreeName(world.getName()));
        levelBuilder.key(this.findFreeKey(world.key()));
        levelBuilder.directory(this.findFreePath(world.getWorldFolder().getName()));
        builder.accept(levelBuilder);
        Level clone = levelBuilder.build();
        try {
            Preconditions.checkArgument((this.plugin.getServer().getWorld(clone.key()) == null ? 1 : 0) != 0, (String)"World with key %s already exists", (Object)clone.key());
            Preconditions.checkArgument((this.plugin.getServer().getWorld(clone.getName()) == null ? 1 : 0) != 0, (String)"World with name %s already exists", (Object)clone.getName());
            Preconditions.checkState((!Files.isDirectory(clone.getDirectory(), new LinkOption[0]) ? 1 : 0) != 0, (Object)"Target directory already exists");
        }
        catch (RuntimeException e) {
            return CompletableFuture.failedFuture(e);
        }
        WorldCloneEvent event = new WorldCloneEvent(world, clone, full);
        event.callEvent();
        return full ? this.saveAsync(world, true).thenCompose(ignored -> {
            try {
                this.copyDirectory(world.getWorldFolder().toPath(), clone.getDirectory(), event.getFileFilter());
                return clone.createAsync();
            }
            catch (IOException e) {
                return CompletableFuture.failedFuture(e);
            }
        }) : clone.createAsync();
    }

    @Override
    public CompletableFuture<LevelView.DeletionResult> deleteAsync(World world, boolean schedule) {
        return this.plugin.supplyGlobal(() -> schedule ? CompletableFuture.completedFuture(this.scheduleDeletion(world)) : this.deleteNow(world));
    }

    @Override
    public boolean cancelScheduledDeletion(World world) {
        return this.deletions.remove(world.key()) != null;
    }

    @Override
    public boolean isDeletionScheduled(World world) {
        return this.deletions.containsKey(world.key());
    }

    @Override
    public CompletableFuture<LevelView.DeletionResult> regenerateAsync(World world, boolean schedule, Consumer<Level.Builder> builder) {
        return this.plugin.supplyGlobal(() -> schedule ? CompletableFuture.completedFuture(this.scheduleRegeneration(world)) : this.regenerateNow(world, builder));
    }

    @Override
    public boolean cancelScheduledRegeneration(World world) {
        return this.regenerations.remove(world.key()) != null;
    }

    @Override
    public boolean isRegenerationScheduled(World world) {
        return this.regenerations.containsKey(world.key());
    }

    private CompletableFuture<LevelView.DeletionResult> deleteNow(World world) {
        if (this.isOverworld(world)) {
            return CompletableFuture.completedFuture(LevelView.DeletionResult.REQUIRES_SCHEDULING);
        }
        if (!new WorldDeleteEvent(world).callEvent()) {
            return CompletableFuture.completedFuture(LevelView.DeletionResult.FAILED);
        }
        Location fallback = this.getOverworld().getSpawnLocation();
        return CompletableFuture.allOf((CompletableFuture[])world.getPlayers().stream().map(player -> player.teleportAsync(fallback, PlayerTeleportEvent.TeleportCause.PLUGIN).thenAccept(success -> {
            if (!success.booleanValue()) {
                player.kick(this.plugin.bundle().component("world.unload.kicked", (Audience)player));
            }
        })).toArray(CompletableFuture[]::new)).thenCompose(ignored -> ((CompletableFuture)this.unloadAsync(world, false).thenApplyAsync(success -> {
            if (!success.booleanValue()) {
                return LevelView.DeletionResult.UNLOAD_FAILED;
            }
            this.delete(world.getWorldFolder().toPath());
            this.deletions.remove(world.key());
            return LevelView.DeletionResult.SUCCESS;
        })).exceptionally(throwable -> {
            this.plugin.getComponentLogger().warn("Failed to delete world", throwable);
            return LevelView.DeletionResult.FAILED;
        }));
    }

    private LevelView.DeletionResult scheduleDeletion(World world) {
        return this.scheduleAction(world, WorldActionScheduledEvent.ActionType.DELETE, this.deletions, this::delete);
    }

    private LevelView.DeletionResult scheduleAction(World world, WorldActionScheduledEvent.ActionType type, Map<Key, Runnable> map, Consumer<Path> consumer) {
        if (map.containsKey(world.key())) {
            return LevelView.DeletionResult.SCHEDULED;
        }
        WorldActionScheduledEvent event = new WorldActionScheduledEvent(world, type);
        if (!event.callEvent()) {
            return LevelView.DeletionResult.FAILED;
        }
        Consumer<Path> action = event.getAction() == null ? consumer : event.getAction().andThen(consumer);
        Path path = world.getWorldFolder().toPath();
        map.put(world.key(), () -> action.accept(path));
        return LevelView.DeletionResult.SCHEDULED;
    }

    private CompletableFuture<LevelView.DeletionResult> regenerateNow(World world, Consumer<Level.Builder> consumer) {
        if (this.isOverworld(world)) {
            return CompletableFuture.completedFuture(LevelView.DeletionResult.REQUIRES_SCHEDULING);
        }
        if (!new WorldRegenerateEvent(world).callEvent()) {
            return CompletableFuture.completedFuture(LevelView.DeletionResult.FAILED);
        }
        List players = world.getPlayers();
        Location fallback = this.getOverworld().getSpawnLocation();
        return CompletableFuture.allOf((CompletableFuture[])players.stream().map(player -> player.teleportAsync(fallback, PlayerTeleportEvent.TeleportCause.PLUGIN).thenAccept(success -> {
            if (!success.booleanValue()) {
                player.kick(this.plugin.bundle().component("world.unload.kicked", (Audience)player));
            }
        })).toArray(CompletableFuture[]::new)).thenCompose(ignored -> ((CompletableFuture)this.saveLevelDataAsync(world).thenCompose(ignored1 -> ((CompletableFuture)this.unloadAsync(world, false).thenCompose(success -> {
            if (!success.booleanValue()) {
                return CompletableFuture.completedFuture(LevelView.DeletionResult.UNLOAD_FAILED);
            }
            this.regenerate(world.getWorldFolder().toPath());
            this.regenerations.remove(world.key());
            Level.Builder builder = this.plugin.levelBuilder(world);
            consumer.accept(builder);
            return ((CompletableFuture)builder.build().createAsync().thenAccept(regenerated -> players.forEach(player -> player.teleportAsync(regenerated.getSpawnLocation(), PlayerTeleportEvent.TeleportCause.PLUGIN)))).thenApply(ignored2 -> LevelView.DeletionResult.SUCCESS);
        })).exceptionally(throwable -> {
            this.plugin.getComponentLogger().warn("Failed to regenerate world", throwable);
            return LevelView.DeletionResult.FAILED;
        }))).exceptionally(throwable -> {
            this.plugin.getComponentLogger().warn("Failed to save level data before regeneration", throwable);
            return LevelView.DeletionResult.FAILED;
        }));
    }

    private LevelView.DeletionResult scheduleRegeneration(World world) {
        return this.scheduleAction(world, WorldActionScheduledEvent.ActionType.REGENERATE, this.regenerations, this::regenerate);
    }

    private void regenerate(Path level) {
        this.delete(level.resolve("DIM-1"));
        this.delete(level.resolve("DIM1"));
        this.delete(level.resolve("advancements"));
        this.delete(level.resolve("data"));
        this.delete(level.resolve("entities"));
        this.delete(level.resolve("playerdata"));
        this.delete(level.resolve("poi"));
        this.delete(level.resolve("region"));
        this.delete(level.resolve("stats"));
    }

    private void delete(Path path) {
        block9: {
            try {
                if (!Files.isDirectory(path, new LinkOption[0])) {
                    Files.deleteIfExists(path);
                    break block9;
                }
                try (Stream<Path> files = Files.list(path);){
                    files.forEach(this::delete);
                    Files.deleteIfExists(path);
                }
            }
            catch (IOException e) {
                this.plugin.getComponentLogger().warn("Failed to delete {}", (Object)path, (Object)e);
            }
        }
    }

    public void copyDirectory(final Path source, final Path destination, final @Nullable BiPredicate<Path, BasicFileAttributes> filter) throws IOException {
        Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attributes) throws IOException {
                if (SKIP_DIRECTORIES.contains(path.getFileName().toString())) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (filter != null && !filter.test(path, attributes)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                Files.createDirectories(destination.resolve(source.relativize(path)), new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attributes) throws IOException {
                if (SKIP_FILES.contains(path.getFileName().toString())) {
                    return FileVisitResult.CONTINUE;
                }
                if (filter != null && !filter.test(path, attributes)) {
                    return FileVisitResult.CONTINUE;
                }
                Files.copy(path, destination.resolve(source.relativize(path)), new CopyOption[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path path, IOException exc) {
                PaperLevelView.this.plugin.getComponentLogger().warn("Failed to copy file: {}", (Object)path, (Object)exc);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private record RestoringResultImpl(@Nullable World world, LevelView.DeletionResult result) implements LevelView.RestoringResult
    {
    }
}

