/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.nbt.tag;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.thenextlvl.nbt.NBTOutputStream;
import net.thenextlvl.nbt.tag.ListTag;
import net.thenextlvl.nbt.tag.Tag;
import net.thenextlvl.nbt.tag.ValueTagImpl;
import org.jspecify.annotations.Nullable;

final class ListTagImpl<T extends Tag>
extends ValueTagImpl<List<T>>
implements ListTag<T> {
    private final byte contentTypeId;

    private ListTagImpl(List<T> value, byte contentTypeId) {
        super(Collections.unmodifiableList(new LinkedList<T>(value)));
        this.contentTypeId = contentTypeId;
    }

    public ListTagImpl(byte contentTypeId) {
        super(Collections.emptyList());
        this.contentTypeId = contentTypeId;
    }

    @Override
    public byte getContentTypeId() {
        return this.contentTypeId;
    }

    @Override
    public boolean isList() {
        return true;
    }

    public ListTagImpl<T> getAsList() {
        return this;
    }

    @Override
    public byte getTypeId() {
        return 9;
    }

    @Override
    public int size() {
        return ((List)this.value).size();
    }

    @Override
    public T get(int index) {
        return (T)((Tag)((List)this.value).get(index));
    }

    @Override
    public T set(int i, T t) {
        throw new UnsupportedOperationException("ListTag is immutable");
    }

    @Override
    public void add(int i, T t) {
        throw new UnsupportedOperationException("ListTag is immutable");
    }

    @Override
    public T remove(int i) {
        throw new UnsupportedOperationException("ListTag is immutable");
    }

    @Override
    public int indexOf(Object o) {
        return ((List)this.value).indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return ((List)this.value).lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return ((List)this.value).listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int i) {
        return ((List)this.value).listIterator(i);
    }

    @Override
    public List<T> subList(int i, int i1) {
        return ((List)this.value).subList(i, i1);
    }

    @Override
    public boolean isEmpty() {
        return ((List)this.value).isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return ((List)this.value).contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return ((List)this.value).iterator();
    }

    @Override
    public Object[] toArray() {
        return ((List)this.value).toArray();
    }

    @Override
    public <V> V[] toArray(V[] vs) {
        return ((List)this.value).toArray(vs);
    }

    @Override
    public boolean add(T t) {
        throw new UnsupportedOperationException("ListTag is immutable");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("ListTag is immutable");
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return new HashSet((Collection)this.value).containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        throw new UnsupportedOperationException("ListTag is immutable");
    }

    @Override
    public boolean addAll(int i, Collection<? extends T> collection) {
        throw new UnsupportedOperationException("ListTag is immutable");
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException("ListTag is immutable");
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException("ListTag is immutable");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("ListTag is immutable");
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ListTagImpl listTag = (ListTagImpl)o;
        return this.contentTypeId == listTag.contentTypeId;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.contentTypeId);
    }

    @Override
    public void write(NBTOutputStream outputStream) throws IOException {
        outputStream.writeByte(this.contentTypeId);
        outputStream.writeInt(((List)this.value).size());
        for (Tag tag : (List)this.value) {
            tag.write(outputStream);
        }
    }

    @Override
    public String toString() {
        if (((List)this.value).isEmpty()) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder("[");
        for (int i = 0; i < ((List)this.value).size(); ++i) {
            if (i > 0) {
                builder.append(",");
            }
            builder.append(((List)this.value).get(i));
        }
        return builder.append(']').toString();
    }

    public static final class Builder<T extends Tag>
    implements ListTag.Builder<T> {
        private final List<T> value = new LinkedList<T>();
        private @Nullable Byte contentTypeId;

        @Override
        public ListTag.Builder<T> contentType(byte contentTypeId) throws IllegalStateException {
            if (this.contentTypeId != null && !this.value.isEmpty()) {
                throw new IllegalStateException("Content type cannot be changed after adding values");
            }
            this.contentTypeId = contentTypeId;
            return this;
        }

        @Override
        public ListTag.Builder<T> add(T tag) throws IllegalArgumentException {
            return this.addLast(tag);
        }

        @Override
        public ListTag.Builder<T> add(int index, T tag) throws IllegalArgumentException {
            this.checkOrReplaceContentType(tag);
            this.value.add(index, tag);
            return this;
        }

        @Override
        public ListTag.Builder<T> addFirst(T tag) throws IllegalArgumentException {
            return this.add(0, tag);
        }

        @Override
        public ListTag.Builder<T> addLast(T tag) throws IllegalArgumentException {
            return this.add(this.value.size(), tag);
        }

        @Override
        public ListTag.Builder<T> addAll(Iterable<? extends T> iterable) throws IllegalArgumentException {
            iterable.forEach(this::add);
            return this;
        }

        @Override
        public ListTag.Builder<T> replaceAll(UnaryOperator<T> operator) throws IllegalArgumentException {
            ListIterator<T> li = this.value.listIterator();
            while (li.hasNext()) {
                this.set(li.nextIndex(), (Tag)operator.apply((Tag)li.next()));
            }
            return this;
        }

        @Override
        public ListTag.Builder<T> set(int index, T tag) throws IllegalArgumentException {
            this.checkOrReplaceContentType(tag);
            this.value.set(index, tag);
            return this;
        }

        @Override
        public ListTag.Builder<T> remove(T tag) {
            this.value.remove(tag);
            return this;
        }

        @Override
        public ListTag.Builder<T> removeIf(Predicate<? super T> filter) {
            this.value.removeIf(filter);
            return this;
        }

        @Override
        public ListTag.Builder<T> removeAll(Iterable<? extends T> iterable) throws IllegalArgumentException {
            iterable.forEach(this.value::remove);
            return this;
        }

        @Override
        public ListTag.Builder<T> clear() {
            this.value.clear();
            return this;
        }

        @Override
        public boolean isEmpty() {
            return this.value.isEmpty();
        }

        @Override
        public int size() {
            return this.value.size();
        }

        @Override
        public ListTag<T> build() {
            if (this.contentTypeId == null) {
                throw new IllegalStateException("Empty ListTag must have a content type");
            }
            return new ListTagImpl<T>(this.value, this.contentTypeId);
        }

        private void checkOrReplaceContentType(T tag) {
            if (this.contentTypeId == null) {
                this.contentTypeId = tag.getTypeId();
            } else if (this.contentTypeId.byteValue() != tag.getTypeId()) {
                throw new IllegalArgumentException("ListTag content type mismatch");
            }
        }
    }
}

