/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.api.preset;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.thenextlvl.worlds.api.preset.Biome;
import net.thenextlvl.worlds.api.preset.Layer;
import net.thenextlvl.worlds.api.preset.Structure;
import org.bukkit.Material;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class Preset {
    private final @Nullable String name;
    private Biome biome = Biome.literal("plains");
    private boolean lakes;
    private boolean features;
    private boolean decoration;
    private LinkedHashSet<Layer> layers = new LinkedHashSet();
    private LinkedHashSet<Structure> structures = new LinkedHashSet();

    public Preset() {
        this(null);
    }

    public Preset(@Nullable String name) {
        this.name = name;
    }

    @Contract(pure=true)
    public static Preset parse(String presetCode) {
        String[] strings = presetCode.split(";", 2);
        LinkedHashSet layers = Arrays.stream(strings[0].split(",")).map(layer -> {
            String[] parameters = layer.split("\\*", 2);
            String material = parameters.length == 1 ? parameters[0] : parameters[1];
            int height = parameters.length == 1 ? 1 : Integer.parseInt(parameters[0]);
            Material matched = Material.matchMaterial((String)material);
            if (matched != null) {
                return new Layer(matched, height);
            }
            throw new IllegalArgumentException("Invalid material: " + material);
        }).collect(Collectors.toCollection(LinkedHashSet::new));
        return new Preset(null).layers(layers).biome(Biome.literal(strings[1]));
    }

    @Contract(pure=true)
    public @Nullable String name() {
        return this.name;
    }

    @Contract(pure=true)
    public Biome biome() {
        return this.biome;
    }

    @Contract(value="_ -> this", mutates="this")
    public Preset biome(Biome biome) {
        this.biome = biome;
        return this;
    }

    @Contract(pure=true)
    public boolean lakes() {
        return this.lakes;
    }

    @Contract(value="_ -> this", mutates="this")
    public Preset lakes(boolean lakes) {
        this.lakes = lakes;
        return this;
    }

    @Contract(pure=true)
    public boolean features() {
        return this.features;
    }

    @Contract(value="_ -> this", mutates="this")
    public Preset features(boolean features) {
        this.features = features;
        return this;
    }

    @Contract(pure=true)
    public boolean decoration() {
        return this.decoration;
    }

    @Contract(value="_ -> this", mutates="this")
    public Preset decoration(boolean decoration) {
        this.decoration = decoration;
        return this;
    }

    @Contract(pure=true)
    public @Unmodifiable Set<Layer> layers() {
        return Set.copyOf(this.layers);
    }

    @Contract(value="_ -> this", mutates="this")
    public Preset layers(Set<Layer> layers) {
        this.layers = new LinkedHashSet<Layer>(layers);
        return this;
    }

    @Contract(pure=true)
    public @Unmodifiable Set<Structure> structures() {
        return Set.copyOf(this.structures);
    }

    @Contract(value="_ -> this", mutates="this")
    public Preset structures(Set<Structure> structures) {
        this.structures = new LinkedHashSet<Structure>(structures);
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    public Preset addLayer(Layer layer) {
        this.layers.add(layer);
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    public Preset addStructure(Structure structure) {
        this.structures.add(structure);
        return this;
    }

    @Contract(pure=true)
    public String toPresetCode() {
        String layers = this.layers.stream().map(Layer::toString).collect(Collectors.joining(","));
        return layers + ";" + String.valueOf(this.biome());
    }

    @Contract(value=" -> new", pure=true)
    public JsonObject serialize() {
        JsonObject root = new JsonObject();
        JsonArray layers = new JsonArray();
        JsonArray structures = new JsonArray();
        root.addProperty("name", this.name);
        root.addProperty("biome", this.biome.key().asString());
        root.addProperty("lakes", Boolean.valueOf(this.lakes));
        root.addProperty("features", Boolean.valueOf(this.features));
        root.addProperty("decoration", Boolean.valueOf(this.decoration));
        this.layers.forEach(layer -> {
            JsonObject object = new JsonObject();
            object.addProperty("block", layer.block().key().asString());
            object.addProperty("height", (Number)layer.height());
            layers.add((JsonElement)object);
        });
        this.structures.forEach(structure -> structures.add(structure.key().asString()));
        root.add("layers", (JsonElement)layers);
        root.add("structure_overrides", (JsonElement)structures);
        return root;
    }

    @Contract(value="_ -> new", pure=true)
    public static Preset deserialize(JsonObject object) throws IllegalArgumentException {
        Preconditions.checkArgument((boolean)object.has("layers"), (Object)"Missing layers");
        Preset preset = new Preset(object.has("name") ? object.get("name").getAsString() : null);
        if (object.has("biome")) {
            preset.biome(Biome.literal(object.get("biome").getAsString()));
        }
        if (object.has("lakes")) {
            preset.lakes(object.get("lakes").getAsBoolean());
        }
        if (object.has("features")) {
            preset.features(object.get("features").getAsBoolean());
        }
        if (object.has("decoration")) {
            preset.decoration(object.get("decoration").getAsBoolean());
        }
        object.getAsJsonArray("layers").forEach(layer -> {
            JsonObject layerObject = layer.getAsJsonObject();
            Material material = Material.matchMaterial((String)layerObject.get("block").getAsString());
            int height = layerObject.get("height").getAsInt();
            if (material != null) {
                preset.addLayer(new Layer(material, height));
            }
        });
        if (object.has("structure_overrides")) {
            object.getAsJsonArray("structure_overrides").forEach(structure -> preset.addStructure(Structure.literal(structure.getAsString())));
        }
        return preset;
    }

    public String toString() {
        return "Preset{name='" + this.name + "', biome=" + String.valueOf(this.biome) + ", lakes=" + this.lakes + ", features=" + this.features + ", decoration=" + this.decoration + ", layers=" + String.valueOf(this.layers) + ", structures=" + String.valueOf(this.structures) + "}";
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Preset preset = (Preset)o;
        return this.lakes == preset.lakes && this.features == preset.features && this.decoration == preset.decoration && Objects.equals(this.name, preset.name) && Objects.equals(this.biome, preset.biome) && Objects.equals(this.layers, preset.layers) && Objects.equals(this.structures, preset.structures);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.biome, this.lakes, this.features, this.decoration, this.layers, this.structures);
    }
}

