/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.version;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.thenextlvl.version.Version;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.Contract;

public interface VersionChecker<N, V extends Version> {
    @Contract(pure=true)
    public V getVersionRunning();

    @Contract(value="_ -> new", pure=true)
    public V parseVersion(N var1);

    @Contract(value="_ -> new", pure=true)
    public V parseVersion(String var1);

    @Contract(pure=true)
    public boolean isSupported(N var1);

    @CheckReturnValue
    public CompletableFuture<V> retrieveLatestVersion();

    @CheckReturnValue
    public CompletableFuture<Optional<V>> retrieveLatestSupportedVersion();

    @CheckReturnValue
    public CompletableFuture<Set<V>> retrieveVersions();

    @CheckReturnValue
    public Set<V> getSupportedVersions();

    @CheckReturnValue
    public Set<V> getVersions();

    @CheckReturnValue
    public Optional<V> getLatestSupportedVersion();

    @CheckReturnValue
    public Optional<V> getLatestVersion();
}

