/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.nbt.tag;

import java.io.IOException;
import java.util.Arrays;
import net.thenextlvl.nbt.NBTOutputStream;
import net.thenextlvl.nbt.tag.IntArrayTag;
import net.thenextlvl.nbt.tag.ValueTagImpl;

final class IntArrayTagImpl
extends ValueTagImpl<int[]>
implements IntArrayTag {
    public IntArrayTagImpl(int ... value) {
        super(value);
    }

    @Override
    public int[] getAsIntArray() {
        return this.getValue();
    }

    @Override
    public byte getTypeId() {
        return 11;
    }

    @Override
    public int size() {
        return ((int[])this.value).length;
    }

    @Override
    public Integer get(int index) {
        return ((int[])this.value)[index];
    }

    @Override
    public int[] getValue() {
        return (int[])((int[])this.value).clone();
    }

    @Override
    public void write(NBTOutputStream outputStream) throws IOException {
        outputStream.writeInt(((int[])this.value).length);
        for (int i : (int[])this.value) {
            outputStream.writeInt(i);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IntArrayTagImpl)) {
            return false;
        }
        IntArrayTagImpl valueTag = (IntArrayTagImpl)object;
        return Arrays.equals((int[])this.value, (int[])valueTag.value);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode((int[])this.value);
    }

    @Override
    public String toString() {
        if (((int[])this.value).length == 0) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder("[");
        for (int i = 0; i < ((int[])this.value).length; ++i) {
            if (i > 0) {
                builder.append(",");
            }
            builder.append(((int[])this.value)[i]);
        }
        return builder.append(']').toString();
    }
}

