/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.nbt.tag.impl;

import java.io.IOException;
import net.thenextlvl.nbt.NBTInputStream;
import net.thenextlvl.nbt.NBTOutputStream;
import net.thenextlvl.nbt.tag.IntArrayTag;
import net.thenextlvl.nbt.tag.impl.ValueTagImpl;

public final class IntArrayTagImpl
extends ValueTagImpl<int[]>
implements IntArrayTag {
    public IntArrayTagImpl(int ... value) {
        super(value);
    }

    @Override
    public int getTypeId() {
        return 11;
    }

    @Override
    public int size() {
        return ((int[])this.getValue()).length;
    }

    @Override
    public Integer get(int index) {
        return ((int[])this.getValue())[index];
    }

    @Override
    public void set(int index, Integer element) {
        ((int[])this.getValue())[index] = element;
    }

    @Override
    public void write(NBTOutputStream outputStream) throws IOException {
        outputStream.writeInt(((int[])this.getValue()).length);
        for (int i : (int[])this.getValue()) {
            outputStream.writeInt(i);
        }
    }

    public static IntArrayTagImpl read(NBTInputStream inputStream) throws IOException {
        int length = inputStream.readInt();
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = inputStream.readInt();
        }
        return new IntArrayTagImpl(array);
    }
}

