/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.nbt;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import net.thenextlvl.nbt.tag.EscapeTag;
import net.thenextlvl.nbt.tag.Tag;
import net.thenextlvl.nbt.tag.impl.ByteArrayTagImpl;
import net.thenextlvl.nbt.tag.impl.ByteTagImpl;
import net.thenextlvl.nbt.tag.impl.CompoundTagImpl;
import net.thenextlvl.nbt.tag.impl.DoubleTagImpl;
import net.thenextlvl.nbt.tag.impl.FloatTagImpl;
import net.thenextlvl.nbt.tag.impl.IntArrayTagImpl;
import net.thenextlvl.nbt.tag.impl.IntTagImpl;
import net.thenextlvl.nbt.tag.impl.ListTagImpl;
import net.thenextlvl.nbt.tag.impl.LongArrayTagImpl;
import net.thenextlvl.nbt.tag.impl.LongTagImpl;
import net.thenextlvl.nbt.tag.impl.ShortTagImpl;
import net.thenextlvl.nbt.tag.impl.StringTagImpl;
import org.jetbrains.annotations.Contract;

public final class NBTInputStream
extends DataInputStream {
    private final Charset charset;
    private final Map<Integer, MappingFunction> mapper = new HashMap<Integer, MappingFunction>(Map.ofEntries(Map.entry(7, ByteArrayTagImpl::read), Map.entry(1, ByteTagImpl::read), Map.entry(10, CompoundTagImpl::read), Map.entry(6, DoubleTagImpl::read), Map.entry(0, ignored -> EscapeTag.INSTANCE), Map.entry(5, FloatTagImpl::read), Map.entry(11, IntArrayTagImpl::read), Map.entry(3, IntTagImpl::read), Map.entry(9, ListTagImpl::read), Map.entry(12, LongArrayTagImpl::read), Map.entry(4, LongTagImpl::read), Map.entry(2, ShortTagImpl::read), Map.entry(8, StringTagImpl::read)));

    public NBTInputStream(InputStream inputStream) throws IOException {
        this(inputStream, StandardCharsets.UTF_8);
    }

    public NBTInputStream(InputStream inputStream, Charset charset) throws IOException {
        super(new DataInputStream(new GZIPInputStream(inputStream)));
        this.charset = charset;
    }

    @Contract(value=" -> new", mutates="this")
    public Tag readTag() throws IOException {
        return this.readNamedTag().getKey();
    }

    @Contract(value=" -> new", mutates="this")
    public Map.Entry<Tag, Optional<String>> readNamedTag() throws IOException {
        byte type = this.readByte();
        if (type == 0) {
            return Map.entry(EscapeTag.INSTANCE, Optional.empty());
        }
        byte[] bytes = new byte[this.readShort()];
        this.readFully(bytes);
        String name = bytes.length == 0 ? null : new String(bytes, this.getCharset());
        return Map.entry(this.readTag(type), Optional.ofNullable(name));
    }

    @Contract(value="_ -> new", mutates="this")
    public Tag readTag(int type) throws IOException {
        MappingFunction mapping = this.mapper.get(type);
        if (mapping != null) {
            return mapping.map(this);
        }
        throw new IllegalArgumentException("Unknown tag type: " + type);
    }

    @Contract(pure=true)
    public Charset getCharset() {
        return this.charset;
    }

    @Contract(mutates="this")
    public void registerMapping(int typeId, MappingFunction function) {
        this.mapper.put(typeId, function);
    }

    @FunctionalInterface
    public static interface MappingFunction {
        @Contract(value="_ -> new", mutates="param1")
        public Tag map(NBTInputStream var1) throws IOException;
    }
}

