/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.command.argument;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import core.file.formats.JsonFile;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.thenextlvl.worlds.WorldsPlugin;
import net.thenextlvl.worlds.api.preset.Preset;
import net.thenextlvl.worlds.api.preset.Presets;
import net.thenextlvl.worlds.command.argument.SimpleArgumentType;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class WorldPresetArgument
implements SimpleArgumentType<Preset, String> {
    private static final Map<String, Preset> identifiers = Presets.presets().stream().filter(preset -> preset.name() != null).collect(Collectors.toMap(preset -> WorldPresetArgument.toIdentifier(Objects.requireNonNull(preset.name(), "Preset name cannot be null")), preset -> preset));
    private final WorldsPlugin plugin;

    public WorldPresetArgument(WorldsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public Preset convert(StringReader reader, String type) {
        Preset optional = identifiers.get(WorldPresetArgument.toIdentifier(type));
        if (optional != null) {
            return optional;
        }
        Path file = this.plugin.presetsFolder().resolve(type + ".json");
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            throw new IllegalStateException("No preset found");
        }
        JsonObject root = (JsonObject)new JsonFile<JsonObject>(file, new JsonObject()).getRoot();
        if (root.isJsonObject()) {
            return Preset.deserialize(root);
        }
        throw new IllegalStateException("Not a valid preset");
    }

    public ArgumentType<String> getNativeType() {
        return StringArgumentType.string();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return ((CompletableFuture)CompletableFuture.runAsync(() -> {
            HashSet<String> presets = new HashSet<String>(identifiers.keySet());
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.plugin.presetsFolder(), "*.json");){
                for (Path path : directoryStream) {
                    String fileName = path.getFileName().toString();
                    String suggestion = fileName.substring(0, fileName.length() - 5);
                    presets.add(suggestion);
                }
            }
            catch (IOException e) {
                this.plugin.getComponentLogger().warn("Failed to read presets from disk", (Throwable)e);
            }
            presets.stream().filter(s -> s.toLowerCase(Locale.ROOT).contains(builder.getRemainingLowerCase())).map(StringArgumentType::escapeIfRequired).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        }).exceptionally(throwable -> {
            this.plugin.getComponentLogger().error("Failed to list presets", throwable);
            return null;
        })).thenApply(ignored -> builder.build());
    }

    private static String toIdentifier(String name) {
        return name.toLowerCase(Locale.ROOT).replace(" ", "-").replace("'", "");
    }
}

