/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.nbt.file;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.thenextlvl.nbt.NBTInputStream;
import net.thenextlvl.nbt.NBTOutputStream;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.nbt.tag.Tag;
import org.jspecify.annotations.Nullable;

@Deprecated(forRemoval=true)
public class NBTFile<R extends CompoundTag> {
    private @Nullable String rootName;
    private final Path file;
    private final Charset charset;
    private R root;
    private boolean loaded;

    public NBTFile(Path file, Charset charset, R root) {
        this.file = file;
        this.root = root;
        this.charset = charset;
    }

    public NBTFile(Path file, R root) {
        this(file, StandardCharsets.UTF_8, root);
    }

    public R getRoot() {
        if (this.loaded) {
            return this.root;
        }
        this.loaded = true;
        this.root = this.load();
        return this.root;
    }

    public NBTFile<R> setRoot(R root) {
        this.loaded = true;
        this.root = root;
        return this;
    }

    public NBTFile<R> reload() {
        return this.setRoot(this.load());
    }

    public NBTFile<R> saveIfAbsent(FileAttribute<?> ... attributes) {
        return Files.isRegularFile(this.file, new LinkOption[0]) ? this : this.save(attributes);
    }

    public Charset getCharset() {
        return this.charset;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected R load() {
        if (!Files.isRegularFile(this.file, new LinkOption[0])) {
            return this.getRoot();
        }
        try (NBTInputStream inputStream = new NBTInputStream(Files.newInputStream(this.file, StandardOpenOption.READ), this.charset);){
            Map.Entry<Tag, Optional<String>> entry = inputStream.readNamedTag();
            entry.getValue().ifPresent(this::setRootName);
            CompoundTag compoundTag = (CompoundTag)entry.getKey();
            return (R)compoundTag;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public NBTFile<R> save(FileAttribute<?> ... attributes) {
        NBTFile nBTFile;
        R root = this.getRoot();
        Files.createDirectories(this.file.toAbsolutePath().getParent(), new FileAttribute[0]);
        NBTOutputStream outputStream = new NBTOutputStream(Files.newOutputStream(this.file, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING), this.charset);
        try {
            outputStream.writeTag(this.getRootName(), (Tag)root);
            nBTFile = this;
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        outputStream.close();
        return nBTFile;
    }

    public @Nullable String getRootName() {
        return this.rootName;
    }

    public void setRootName(@Nullable String rootName) {
        this.rootName = rootName;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NBTFile nbtFile = (NBTFile)o;
        return Objects.equals(this.rootName, nbtFile.rootName) && Objects.equals(this.file, nbtFile.file) && Objects.equals(this.charset, nbtFile.charset);
    }

    public int hashCode() {
        return Objects.hash(this.rootName, this.file, this.charset);
    }

    public String toString() {
        return "NBTFile{rootName='" + this.rootName + "', file=" + String.valueOf(this.file) + ", charset=" + String.valueOf(this.charset) + "}";
    }
}

