/*
 * Decompiled with CFR 0.152.
 */
package dev.faststats.bukkit;

import com.google.gson.JsonObject;
import dev.faststats.bukkit.BukkitMetrics;
import dev.faststats.core.Metrics;
import dev.faststats.core.SimpleMetrics;
import io.papermc.paper.configuration.ServerConfiguration;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Server;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;

final class BukkitMetricsImpl
extends SimpleMetrics
implements BukkitMetrics {
    private final Logger logger;
    private final Server server;
    private final Plugin plugin;

    @Async.Schedule
    @Contract(mutates="io")
    private BukkitMetricsImpl(SimpleMetrics.Factory<?> factory, Plugin plugin, Path config) throws IOException, IllegalStateException {
        super(factory, config);
        this.logger = plugin.getLogger();
        this.server = plugin.getServer();
        this.plugin = plugin;
        this.startSubmitting();
    }

    @Async.Schedule
    private void startSubmitting() {
        this.startSubmitting(30, 1800, TimeUnit.SECONDS);
    }

    private boolean checkOnlineMode() {
        return this.tryOrEmpty(() -> ((ServerConfiguration)this.server.getServerConfig()).isProxyOnlineMode()).or(() -> this.tryOrEmpty(this::isProxyOnlineMode)).orElseGet(() -> ((Server)this.server).getOnlineMode());
    }

    private boolean isProxyOnlineMode() {
        ConfigurationSection proxies = this.server.spigot().getPaperConfig().getConfigurationSection("proxies");
        if (proxies == null) {
            return false;
        }
        if (proxies.getBoolean("velocity.enabled") && proxies.getBoolean("velocity.online-mode")) {
            return true;
        }
        ConfigurationSection settings = this.server.spigot().getSpigotConfig().getConfigurationSection("settings");
        if (settings == null) {
            return false;
        }
        return settings.getBoolean("bungeecord") && proxies.getBoolean("bungee-cord.online-mode");
    }

    @Override
    protected void appendDefaultData(JsonObject charts) {
        String pluginVersion = this.tryOrEmpty(() -> this.plugin.getPluginMeta().getVersion()).orElseGet(() -> this.plugin.getDescription().getVersion());
        String minecraftVersion = this.tryOrEmpty(() -> ((Server)this.server).getMinecraftVersion()).orElseGet(() -> this.server.getBukkitVersion().split("-", 2)[0]);
        charts.addProperty("minecraft_version", minecraftVersion);
        charts.addProperty("online_mode", Boolean.valueOf(this.checkOnlineMode()));
        charts.addProperty("player_count", (Number)this.server.getOnlinePlayers().size());
        charts.addProperty("plugin_version", pluginVersion);
        charts.addProperty("server_type", this.server.getName());
    }

    @Override
    protected void printError(String message, @Nullable Throwable throwable) {
        this.logger.log(Level.SEVERE, message, throwable);
    }

    @Override
    protected void printInfo(String message) {
        this.logger.info(message);
    }

    @Override
    protected void printWarning(String message) {
        this.logger.warning(message);
    }

    private <T> Optional<T> tryOrEmpty(Supplier<T> supplier) {
        try {
            return Optional.of(supplier.get());
        }
        catch (Exception | NoSuchMethodError e) {
            this.error("Failed to call supplier", e);
            return Optional.empty();
        }
    }

    static final class Factory
    extends SimpleMetrics.Factory<Plugin> {
        Factory() {
        }

        @Override
        public Metrics create(Plugin plugin) throws IOException, IllegalStateException {
            Path dataFolder = plugin.getServer().getPluginsFolder().toPath().resolve("faststats");
            Path config = dataFolder.resolve("config.properties");
            return new BukkitMetricsImpl(this, plugin, config);
        }
    }
}

