/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.command.suggestion;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.util.TriState;
import net.thenextlvl.worlds.WorldsPlugin;
import net.thenextlvl.worlds.api.exception.GeneratorException;
import net.thenextlvl.worlds.api.level.Level;
import org.jspecify.annotations.NullMarked;

@NullMarked
public abstract class LevelSuggestionProvider
implements SuggestionProvider<CommandSourceStack> {
    protected final WorldsPlugin plugin;
    private final boolean unknownLevels;

    protected LevelSuggestionProvider(WorldsPlugin plugin, boolean unknownLevels) {
        this.unknownLevels = unknownLevels;
        this.plugin = plugin;
    }

    private Optional<Level.Builder> safeRead(Path path) {
        try {
            return this.plugin.levelView().read(path);
        }
        catch (GeneratorException e) {
            return Optional.empty();
        }
        catch (Exception e) {
            this.plugin.getComponentLogger().error("Failed to read level {}", (Object)path, (Object)e);
            return Optional.empty();
        }
    }

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        return CompletableFuture.runAsync(() -> this.plugin.levelView().listLevels().stream().filter(this.plugin.levelView()::canLoad).map(this::safeRead).map(level -> level.map(Level.Builder::build).orElse(null)).filter(Objects::nonNull).filter(level -> this.unknownLevels ? !level.isWorldKnown() : level.isWorldKnown() && level.isEnabled().equals((Object)TriState.FALSE)).forEach(level -> {
            String name = level.getDirectory().getFileName().toString();
            String escaped = StringArgumentType.escapeIfRequired((String)name);
            if (!escaped.contains(builder.getRemaining())) {
                return;
            }
            builder.suggest(escaped, () -> level.key().asString());
        })).thenApply(ignored -> builder.build());
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return this.getSuggestions(context, builder);
    }
}

