/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.worlds.WorldsPlugin;
import net.thenextlvl.worlds.command.WorldCommand;
import net.thenextlvl.worlds.command.argument.KeyArgument;
import net.thenextlvl.worlds.command.brigadier.OptionCommand;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class WorldCloneCommand
extends OptionCommand {
    private WorldCloneCommand(WorldsPlugin plugin) {
        super(plugin, "clone", "worlds.command.clone");
    }

    public static ArgumentBuilder<CommandSourceStack, ?> create(WorldsPlugin plugin) {
        WorldCloneCommand command = new WorldCloneCommand(plugin);
        return command.create().then(command.createCommand());
    }

    @Override
    protected RequiredArgumentBuilder<CommandSourceStack, ?> createCommand() {
        RequiredArgumentBuilder<CommandSourceStack, World> world = WorldCommand.worldArgument(this.plugin);
        this.addOptions((ArgumentBuilder<CommandSourceStack, ?>)world, false, Set.of(new OptionCommand.Option("full", (ArgumentType<?>)BoolArgumentType.bool()), new OptionCommand.Option("key", (ArgumentType<?>)new KeyArgument()), new OptionCommand.Option("name", (ArgumentType<?>)StringArgumentType.string())), null);
        return (RequiredArgumentBuilder)world.executes((Command)this);
    }

    public int run(CommandContext<CommandSourceStack> context) {
        World world = (World)context.getArgument("world", World.class);
        Boolean full = this.tryGetArgument(context, "full", Boolean.class).orElse(true);
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        TagResolver.Single placeholder = Placeholder.parsed((String)"world", (String)world.getName());
        this.plugin.bundle().sendMessage((Audience)sender, "world.clone", new TagResolver[]{placeholder});
        ((CompletableFuture)this.plugin.levelView().cloneAsync(world, builder -> {
            this.tryGetArgument(context, "name", String.class).ifPresent(builder::name);
            this.tryGetArgument(context, "key", Key.class).ifPresent(builder::key);
        }, full).thenAccept(clone -> {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                player.teleportAsync(clone.getSpawnLocation(), PlayerTeleportEvent.TeleportCause.COMMAND);
            }
            this.plugin.bundle().sendMessage((Audience)sender, "world.clone.success", new TagResolver[]{placeholder});
        })).exceptionally(throwable -> {
            this.plugin.getComponentLogger().warn("Failed to clone world {}", (Object)world.getName(), throwable);
            this.plugin.bundle().sendMessage((Audience)sender, "world.clone.failed", new TagResolver[]{placeholder});
            return null;
        });
        return 1;
    }
}

