/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.api.generator;

import java.util.Set;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;

@NullMarked
@ApiStatus.Experimental
@ApiStatus.NonExtendable
public interface BiomeSource
extends Keyed {
    @Contract(value="_ -> new", pure=true)
    public static CheckerboardColumnBiomeSource checkerboard(Set<Key> biomes) {
        return new CheckerboardColumnBiomeSource(biomes);
    }

    @Contract(value="_ -> new", pure=true)
    public static FixedBiomeSource fixed(Key biome) {
        return new FixedBiomeSource(biome);
    }

    public static final class CheckerboardColumnBiomeSource
    implements BiomeSource {
        private final Key key = Key.key((String)"minecraft", (String)"checkerboard");
        private final Set<Key> biomes;

        private CheckerboardColumnBiomeSource(Set<Key> biomes) {
            this.biomes = Set.copyOf(biomes);
        }

        @Contract(pure=true)
        public @Unmodifiable Set<Key> biomes() {
            return Set.copyOf(this.biomes);
        }

        @Contract(pure=true)
        public Key key() {
            return this.key;
        }
    }

    public static final class FixedBiomeSource
    implements BiomeSource {
        private final Key key = Key.key((String)"minecraft", (String)"fixed");
        private final Key biome;

        private FixedBiomeSource(Key biome) {
            this.biome = biome;
        }

        @Contract(pure=true)
        public Key biome() {
            return this.biome;
        }

        @Contract(pure=true)
        public Key key() {
            return this.key;
        }
    }
}

