/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.nbt.tag.impl;

import java.io.IOException;
import net.thenextlvl.nbt.NBTInputStream;
import net.thenextlvl.nbt.NBTOutputStream;
import net.thenextlvl.nbt.tag.LongArrayTag;
import net.thenextlvl.nbt.tag.impl.ValueTagImpl;

public final class LongArrayTagImpl
extends ValueTagImpl<long[]>
implements LongArrayTag {
    public LongArrayTagImpl(long ... value) {
        super(value);
    }

    @Override
    public int getTypeId() {
        return 12;
    }

    @Override
    public int size() {
        return ((long[])this.getValue()).length;
    }

    @Override
    public Long get(int index) {
        return ((long[])this.getValue())[index];
    }

    @Override
    public void set(int index, Long element) {
        ((long[])this.getValue())[index] = element;
    }

    @Override
    public void write(NBTOutputStream outputStream) throws IOException {
        outputStream.writeLong(((long[])this.getValue()).length);
        for (long l : (long[])this.getValue()) {
            outputStream.writeLong(l);
        }
    }

    public static LongArrayTagImpl read(NBTInputStream inputStream) throws IOException {
        int length = inputStream.readInt();
        long[] array = new long[length];
        for (int i = 0; i < length; ++i) {
            array[i] = inputStream.readLong();
        }
        return new LongArrayTagImpl(array);
    }
}

