/*
 * Decompiled with CFR 0.152.
 */
package dev.faststats.core;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.faststats.core.Metrics;
import dev.faststats.core.Token;
import dev.faststats.core.chart.Chart;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpConnectTimeoutException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

public abstract class SimpleMetrics
implements Metrics {
    protected static final String ONBOARDING_MESSAGE = "This plugin uses FastStats to collect anonymous usage statistics.\nNo personal or identifying information is ever collected.\nTo opt out, set 'enabled=false' in the metrics configuration file.\nLearn more at: https://faststats.dev/info";
    private final HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(3L)).version(HttpClient.Version.HTTP_1_1).build();
    private @Nullable ScheduledExecutorService executor = null;
    private final Set<Chart<?>> charts;
    private final Config config;
    @Token
    private final String token;
    private final URI url;
    private final boolean debug;

    @Contract(mutates="io")
    protected SimpleMetrics(Factory<?> factory, Path config) throws IOException, IllegalStateException {
        if (factory.token == null) {
            throw new IllegalStateException("Token must be specified");
        }
        this.charts = Set.copyOf(factory.charts);
        this.config = new Config(config);
        this.debug = factory.debug;
        this.token = factory.token;
        this.url = factory.url;
    }

    @VisibleForTesting
    protected SimpleMetrics(Config config, Set<Chart<?>> charts, @Token String token, URI url, boolean debug) {
        if (!token.matches("[a-z0-9]{32}")) {
            throw new IllegalArgumentException("Invalid token '" + token + "', must match '[a-z0-9]{32}'");
        }
        this.charts = Set.copyOf(charts);
        this.config = config;
        this.debug = debug;
        this.token = token;
        this.url = url;
    }

    @Async.Schedule
    @MustBeInvokedByOverriders
    protected void startSubmitting(int initialDelay, int period, TimeUnit unit) {
        if (this.config.firstRun) {
            for (String s : ONBOARDING_MESSAGE.split("\n")) {
                this.printInfo(s);
            }
        }
        if (!this.config.enabled()) {
            this.warn("Metrics disabled, not starting submission");
            return;
        }
        if (this.isSubmitting()) {
            this.warn("Metrics already submitting, not starting again");
            return;
        }
        this.executor = Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread thread = new Thread(runnable, "metrics-submitter");
            thread.setDaemon(true);
            return thread;
        });
        this.info("Starting metrics submission");
        this.executor.scheduleAtFixedRate(this::submitData, initialDelay, period, unit);
    }

    protected boolean isSubmitting() {
        return this.executor != null && !this.executor.isShutdown();
    }

    protected void submitData() {
        String data = this.createData().toString();
        byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
        try (ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
             GZIPOutputStream output = new GZIPOutputStream(byteOutput);){
            output.write(bytes);
            output.finish();
            byte[] compressed = byteOutput.toByteArray();
            HttpRequest request = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofByteArray(compressed)).header("Content-Encoding", "gzip").header("Content-Type", "application/octet-stream").header("Authorization", "Bearer " + this.getToken()).header("User-Agent", "FastStats Metrics").timeout(Duration.ofSeconds(3L)).uri(this.url).build();
            this.info("Sending metrics to: " + String.valueOf(this.url));
            this.info("Uncompressed data: " + data);
            this.info("Compressed size: " + compressed.length + " bytes");
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            int statusCode = response.statusCode();
            String body = response.body();
            if (statusCode >= 200 && statusCode < 300) {
                this.info("Metrics submitted with status code: " + statusCode + " (" + body + ")");
            } else if (statusCode >= 300 && statusCode < 400) {
                this.warn("Received redirect response from metrics server: " + statusCode + " (" + body + ")");
            } else if (statusCode >= 400 && statusCode < 500) {
                this.error("Submitted invalid request to metrics server: " + statusCode + " (" + body + ")", null);
            } else if (statusCode >= 500 && statusCode < 600) {
                this.error("Received server error response from metrics server: " + statusCode + " (" + body + ")", null);
            } else {
                this.warn("Received unexpected response from metrics server: " + statusCode + " (" + body + ")");
            }
        }
        catch (HttpConnectTimeoutException e) {
            this.error("Metrics submission timed out after 3 seconds: " + String.valueOf(this.url), null);
        }
        catch (ConnectException e) {
            this.error("Failed to connect to metrics server: " + String.valueOf(this.url), null);
        }
        catch (Exception e) {
            this.error("Failed to submit metrics", e);
        }
    }

    protected JsonObject createData() {
        JsonObject data = new JsonObject();
        JsonObject charts = new JsonObject();
        charts.addProperty("java_version", System.getProperty("java.version"));
        charts.addProperty("os_arch", System.getProperty("os.arch"));
        charts.addProperty("os_name", System.getProperty("os.name"));
        charts.addProperty("os_version", System.getProperty("os.version"));
        charts.addProperty("core_count", (Number)Runtime.getRuntime().availableProcessors());
        this.charts.forEach(chart -> {
            try {
                chart.getData().ifPresent(chartData -> charts.add(chart.getId(), chartData));
            }
            catch (Exception e) {
                this.error("Failed to build chart data: " + chart.getId(), e);
            }
        });
        this.appendDefaultData(charts);
        data.addProperty("server_id", this.config.serverId().toString());
        data.add("data", (JsonElement)charts);
        return data;
    }

    @Override
    @Token
    public String getToken() {
        return this.token;
    }

    @Override
    public Metrics.Config getConfig() {
        return this.config;
    }

    protected boolean isDebug() {
        return this.debug || this.config.debug();
    }

    @Contract(mutates="param1")
    protected abstract void appendDefaultData(JsonObject var1);

    protected void error(String message, @Nullable Throwable throwable) {
        if (this.isDebug()) {
            this.printError("[" + this.getClass().getName() + "]: " + message, throwable);
        }
    }

    protected void warn(String message) {
        if (this.isDebug()) {
            this.printWarning("[" + this.getClass().getName() + "]: " + message);
        }
    }

    protected void info(String message) {
        if (this.isDebug()) {
            this.printInfo("[" + this.getClass().getName() + "]: " + message);
        }
    }

    protected abstract void printError(String var1, @Nullable Throwable var2);

    protected abstract void printInfo(String var1);

    protected abstract void printWarning(String var1);

    @Override
    public void shutdown() {
        this.info("Shutting down metrics submission");
        if (this.executor == null) {
            return;
        }
        this.executor.shutdown();
        this.executor = null;
    }

    public static abstract class Factory<T>
    implements Metrics.Factory<T> {
        private final Set<Chart<?>> charts = new HashSet(0);
        private URI url = URI.create("https://metrics.faststats.dev/v1/collect");
        private @Nullable String token;
        private boolean debug = false;

        @Override
        public Metrics.Factory<T> addChart(Chart<?> chart) throws IllegalArgumentException {
            if (!this.charts.add(chart)) {
                throw new IllegalArgumentException("Chart already added: " + chart.getId());
            }
            return this;
        }

        @Override
        public Metrics.Factory<T> debug(boolean enabled) {
            this.debug = enabled;
            return this;
        }

        @Override
        public Metrics.Factory<T> token(@Token String token) throws IllegalArgumentException {
            if (!token.matches("[a-z0-9]{32}")) {
                throw new IllegalArgumentException("Invalid token '" + token + "', must match '[a-z0-9]{32}'");
            }
            this.token = token;
            return this;
        }

        @Override
        public Metrics.Factory<T> url(URI url) {
            this.url = url;
            return this;
        }
    }

    protected static final class Config
    implements Metrics.Config {
        private final UUID serverId;
        private final boolean debug;
        private final boolean enabled;
        private final boolean firstRun;

        @Contract(mutates="io")
        protected Config(Path file) throws IOException {
            Optional<Properties> properties = Config.readOrEmpty(file);
            this.serverId = properties.map(object -> UUID.fromString(object.getProperty("serverId"))).orElseGet(UUID::randomUUID);
            this.enabled = properties.map(object -> object.getProperty("enabled")).map(Boolean::parseBoolean).orElse(true);
            this.debug = properties.map(object -> object.getProperty("debug")).map(Boolean::parseBoolean).orElse(false);
            this.firstRun = properties.isEmpty();
            if (this.firstRun) {
                Config.create(file, this.serverId);
            }
        }

        @VisibleForTesting
        public Config(UUID serverId, boolean enabled, boolean debug) {
            this.serverId = serverId;
            this.enabled = enabled;
            this.debug = debug;
            this.firstRun = false;
        }

        @Override
        public UUID serverId() {
            return this.serverId;
        }

        @Override
        public boolean enabled() {
            return this.enabled;
        }

        @Override
        public boolean debug() {
            return this.debug;
        }

        private static Optional<Properties> readOrEmpty(Path file) throws IOException {
            if (Files.isRegularFile(file, new LinkOption[0])) {
                return Optional.of(Config.read(file));
            }
            return Optional.empty();
        }

        private static void create(Path file, UUID serverId) throws IOException {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            try (OutputStream out = Files.newOutputStream(file, StandardOpenOption.CREATE_NEW);
                 OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);){
                Properties properties = new Properties();
                properties.setProperty("serverId", serverId.toString());
                properties.setProperty("enabled", Boolean.toString(true));
                properties.setProperty("debug", Boolean.toString(false));
                String comment = " FastStats (https://faststats.dev) gathers basic information for plugin developers,\n# such as the number of users and total player count.\n# Keeping metrics enabled is recommended, but you can disable them if you prefer.\n# Enabling metrics does not affect performance,\n# and all data sent to FastStats is completely anonymous.\n\n# If you suspect a plugin is collecting personal data or bypassing the \"enabled\" option,\n# please report it to the FastStats team (https://faststats.dev/abuse).\n";
                properties.store(writer, comment);
            }
        }

        private static Properties read(Path file) throws IOException {
            try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
                Properties properties = new Properties();
                properties.load(reader);
                Properties properties2 = properties;
                return properties2;
            }
        }
    }
}

