/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.listener;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.util.TriState;
import net.minecraft.util.DirectoryLock;
import net.thenextlvl.worlds.WorldsPlugin;
import net.thenextlvl.worlds.api.exception.GeneratorException;
import net.thenextlvl.worlds.api.level.Level;
import net.thenextlvl.worlds.api.link.LinkTree;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.PluginManager;

public final class WorldListener
implements Listener {
    private final WorldsPlugin plugin;

    public WorldListener(WorldsPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onOverworldLoad(WorldLoadEvent event) {
        this.registerEntryPermission(event.getWorld());
        if (!this.plugin.levelView().isOverworld(event.getWorld())) {
            return;
        }
        this.plugin.levelView().listLevels().stream().filter(this.plugin.levelView()::canLoad).forEach(this::loadLevel);
    }

    private void registerEntryPermission(World world) {
        String permission;
        PluginManager manager = this.plugin.getServer().getPluginManager();
        if (manager.getPermission(permission = this.plugin.levelView().getEntryPermission(world)) != null) {
            return;
        }
        manager.addPermission(new Permission(permission, "Allows entering the world " + world.key().asString() + " (" + world.getName() + ")", PermissionDefault.TRUE));
    }

    private void loadLevel(Path path) {
        Level level = this.plugin.levelView().read(path).map(Level.Builder::build).orElse(null);
        if (level == null || !level.isEnabled().equals((Object)TriState.TRUE)) {
            return;
        }
        if (this.plugin.getServer().getWorld(level.key()) != null) {
            this.plugin.getComponentLogger().warn("Skip loading dimension '{}' because another world with the same key ({}) is already loaded", (Object)path.getFileName(), (Object)level.key());
            return;
        }
        if (this.plugin.getServer().getWorld(level.getName()) != null) {
            this.plugin.getComponentLogger().warn("Skip loading dimension '{}' because another world with the same name ({}) is already loaded", (Object)path.getFileName(), (Object)level.getName());
            return;
        }
        ((CompletableFuture)level.createAsync().thenAccept(world -> this.plugin.getComponentLogger().debug("Loaded dimension {} ({}) from {}", new Object[]{world.key().asString(), level.getGeneratorType().key().asString(), world.getWorldFolder().getPath()}))).exceptionally(throwable -> {
            if (throwable instanceof GeneratorException) {
                GeneratorException e = (GeneratorException)throwable;
                String generator = e.getId() != null ? e.getPlugin() + e.getId() : e.getPlugin();
                this.plugin.getComponentLogger().error("Skip loading dimension '{}'", (Object)path.getFileName());
                this.plugin.getComponentLogger().error("Cannot use generator {}: {}", (Object)generator, (Object)e.getMessage());
            } else {
                Throwable patt0$temp = throwable.getCause();
                if (patt0$temp instanceof DirectoryLock.LockException) {
                    DirectoryLock.LockException lock = (DirectoryLock.LockException)patt0$temp;
                    this.plugin.getComponentLogger().error("Failed to start the minecraft server", (Throwable)lock);
                    this.plugin.getServer().shutdown();
                } else {
                    this.plugin.getComponentLogger().error("An unexpected error occurred while loading the level {}", (Object)path.getFileName(), throwable);
                    this.plugin.getComponentLogger().error("Please report the error above on GitHub: {}", (Object)"https://github.com/TheNextLvl-net/worlds/issues/new/choose");
                }
            }
            return null;
        });
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onWorldLoad(WorldLoadEvent event) {
        this.plugin.linkProvider().loadTree(event.getWorld()).filter(LinkTree::isEmpty).filter(linkTree -> this.plugin.levelView().isOverworld(linkTree.getOverworld())).ifPresent(linkTree -> {
            this.plugin.levelView().getNether().ifPresent(linkTree::setNether);
            this.plugin.levelView().getEnd().ifPresent(linkTree::setEnd);
        });
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onWorldLoad(WorldUnloadEvent event) {
        this.plugin.linkProvider().unloadTree(event.getWorld());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldSave(WorldSaveEvent event) {
        this.plugin.linkProvider().persistTree(event.getWorld());
    }
}

