/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.listener;

import io.papermc.paper.event.entity.EntityPortalReadyEvent;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.PortalProcessor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.Portal;
import net.thenextlvl.worlds.WorldsPlugin;
import net.thenextlvl.worlds.listener.PortalListener;
import org.bukkit.Location;
import org.bukkit.PortalType;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public final class FoliaPortalListener
extends PortalListener {
    private static final int SEARCH_RADIUS_OVERWORLD = 128;
    private static final int SEARCH_RADIUS_NETHER = 16;
    private final Map<UUID, PortalProcessor> portalProcessors = new ConcurrentHashMap<UUID, PortalProcessor>();

    public FoliaPortalListener(WorldsPlugin plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onNetherPortalEnter(EntityPortalEnterEvent event) {
        if (!event.getPortalType().equals((Object)PortalType.NETHER)) {
            return;
        }
        event.setCancelled(true);
        Location location = event.getLocation();
        CraftBlock block = (CraftBlock)location.getBlock();
        Block block2 = block.getNMS().getBlock();
        if (!(block2 instanceof NetherPortalBlock)) {
            return;
        }
        NetherPortalBlock portal = (NetherPortalBlock)block2;
        net.minecraft.world.entity.Entity handle = ((CraftEntity)event.getEntity()).getHandle();
        this.setAsInsidePortal(handle, (Portal)portal, block.getPosition());
        this.handlePortal(block.getPosition(), handle);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityRemove(EntityRemoveEvent event) {
        this.portalProcessors.remove(event.getEntity().getUniqueId());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.portalProcessors.remove(event.getPlayer().getUniqueId());
    }

    private void setAsInsidePortal(net.minecraft.world.entity.Entity entity, Portal portal, BlockPos pos) {
        if (entity.isOnPortalCooldown()) {
            entity.setPortalCooldown();
        } else {
            PortalProcessor process = this.portalProcessors.get(entity.getUUID());
            if (process == null || !process.isSamePortal(portal)) {
                this.portalProcessors.put(entity.getUUID(), new PortalProcessor(portal, pos.immutable()));
            } else if (!process.isInsidePortalThisTick()) {
                process.updateEntryPosition(pos.immutable());
                process.setAsInsidePortalThisTick(true);
            }
        }
    }

    private void handlePortal(BlockPos position, net.minecraft.world.entity.Entity entity) {
        Level level = entity.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        PortalProcessor processor = this.portalProcessors.get(entity.getUUID());
        if (processor == null) {
            return;
        }
        this.processPortalCooldown(entity);
        if (processor.processPortalTeleportation(serverLevel, entity, entity.canUsePortal(false))) {
            ProfilerFiller profilerFiller = Profiler.get();
            profilerFiller.push("portal");
            entity.setPortalCooldown();
            entity.getBukkitEntity().getScheduler().run((Plugin)this.plugin, scheduledTask -> {
                try {
                    this.performPlayerTeleport(entity, processor, position);
                }
                finally {
                    profilerFiller.pop();
                }
            }, null);
        } else if (processor.hasExpired()) {
            this.portalProcessors.remove(entity.getUUID());
        }
    }

    private void processPortalCooldown(net.minecraft.world.entity.Entity entity) {
        if (entity.isOnPortalCooldown()) {
            --entity.portalCooldown;
        }
    }

    private <T extends Enum<T>> void performPlayerTeleport(net.minecraft.world.entity.Entity entity, PortalProcessor processor, BlockPos position) {
        EntityPortalReadyEvent readyEvent = new EntityPortalReadyEvent((Entity)entity.getBukkitEntity(), null, PortalType.NETHER);
        this.onEntityPortal(readyEvent);
        this.portalProcessors.remove(entity.getUUID());
        World targetWorld = readyEvent.getTargetWorld();
        if (targetWorld != null) {
            try {
                ServerLevel level = ((CraftWorld)targetWorld).getHandle();
                Class portalType = Arrays.stream(net.minecraft.world.entity.Entity.class.getDeclaredClasses()).filter(c -> c.getSimpleName().equals("PortalType")).findAny().orElseThrow(() -> new IllegalStateException("PortalType class not found"));
                Method portalToAsync = net.minecraft.world.entity.Entity.class.getDeclaredMethod("portalToAsync", ServerLevel.class, BlockPos.class, Boolean.TYPE, portalType, Consumer.class);
                boolean access = portalToAsync.canAccess(entity);
                if (!access) {
                    portalToAsync.setAccessible(true);
                }
                Object nether = Enum.valueOf(portalType, "NETHER");
                portalToAsync.invoke((Object)entity, level, position, true, nether, null);
                portalToAsync.setAccessible(access);
            }
            catch (Exception e) {
                this.plugin.getComponentLogger().error("Failed to find portalToAsync method for Entity class", (Throwable)e);
            }
        }
    }
}

