/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.nbt.tag.impl;

import java.io.IOException;
import net.thenextlvl.nbt.NBTInputStream;
import net.thenextlvl.nbt.NBTOutputStream;
import net.thenextlvl.nbt.tag.ByteArrayTag;
import net.thenextlvl.nbt.tag.impl.ValueTagImpl;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class ByteArrayTagImpl
extends ValueTagImpl<byte[]>
implements ByteArrayTag {
    public ByteArrayTagImpl(byte ... array) {
        super(array);
    }

    @Override
    public int getTypeId() {
        return 7;
    }

    @Override
    @Contract(pure=true)
    public int size() {
        return ((byte[])this.getValue()).length;
    }

    @Override
    @Contract(pure=true)
    public Byte get(int index) {
        return ((byte[])this.getValue())[index];
    }

    @Override
    @Contract(mutates="this")
    public void set(int index, Byte element) {
        ((byte[])this.getValue())[index] = element;
    }

    @Override
    public void write(NBTOutputStream outputStream) throws IOException {
        outputStream.writeInt(((byte[])this.getValue()).length);
        outputStream.write((byte[])this.getValue());
    }

    public static ByteArrayTagImpl read(NBTInputStream inputStream) throws IOException {
        int length = inputStream.readInt();
        byte[] bytes = new byte[length];
        inputStream.readFully(bytes);
        return new ByteArrayTagImpl(bytes);
    }
}

