/*
 * Decompiled with CFR 0.152.
 */
package core.io;

import core.io.IO;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class StreamIO
implements IO,
AutoCloseable {
    private final @Nullable InputStream inputStream;
    private final @Nullable OutputStream outputStream;

    StreamIO(@Nullable InputStream inputStream, @Nullable OutputStream outputStream) {
        this.inputStream = inputStream;
        this.outputStream = outputStream;
    }

    public boolean isReadable() {
        return this.inputStream != null;
    }

    public boolean isWritable() {
        return this.outputStream != null;
    }

    @Override
    public InputStream inputStream(OpenOption ... options) {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        throw new IllegalStateException("This object is write only");
    }

    @Override
    public OutputStream outputStream(OpenOption ... options) {
        if (this.outputStream != null) {
            return this.outputStream;
        }
        throw new IllegalStateException("This object is read only");
    }

    @Override
    public boolean createParents(FileAttribute<?> ... attributes) {
        return true;
    }

    @Override
    public boolean exists(LinkOption ... options) {
        return true;
    }

    @Override
    public boolean delete() {
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
        if (this.outputStream != null) {
            this.outputStream.close();
        }
    }
}

