/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.listener;

import io.papermc.paper.event.player.AsyncPlayerSpawnLocationEvent;
import net.thenextlvl.tweaks.TweaksPlugin;
import net.thenextlvl.tweaks.model.PluginConfig;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class SpawnListener
implements Listener {
    private final TweaksPlugin plugin;

    public SpawnListener(TweaksPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerSpawnLocation(AsyncPlayerSpawnLocationEvent event) {
        PluginConfig.SpawnConfig config = this.plugin.config().spawn;
        if (config.location == null || !config.location.isWorldLoaded()) {
            return;
        }
        if (!(config.teleportOnFirstJoin && event.isNewPlayer() || config.teleportOnJoin && !event.isNewPlayer())) {
            return;
        }
        event.setSpawnLocation((Location)config.location);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        if (!event.getRespawnReason().equals((Object)PlayerRespawnEvent.RespawnReason.DEATH)) {
            return;
        }
        PluginConfig.SpawnConfig config = this.plugin.config().spawn;
        if (config.location == null || !config.location.isWorldLoaded() || !config.teleportOnRespawn) {
            return;
        }
        if (!config.ignoreRespawnPosition && (event.isAnchorSpawn() || event.isBedSpawn())) {
            return;
        }
        event.setRespawnLocation((Location)config.location);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerDeath(PlayerDeathEvent event) {
        PluginConfig.SpawnConfig config = this.plugin.config().spawn;
        if (config.location == null || !config.location.isWorldLoaded() || !config.teleportOnRespawn) {
            return;
        }
        if (config.ignoreRespawnPosition) {
            event.getPlayer().setRespawnLocation(null);
        }
    }
}

