/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.listener;

import net.thenextlvl.tweaks.TweaksPlugin;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class BackListener
implements Listener {
    private final TweaksPlugin plugin;
    private final BlockFace[] faces = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST, BlockFace.NORTH_EAST, BlockFace.NORTH_WEST, BlockFace.SOUTH_EAST, BlockFace.SOUTH_WEST};

    public BackListener(TweaksPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onMove(PlayerMoveEvent event) {
        if (!event.hasChangedBlock()) {
            return;
        }
        if (!event.getPlayer().isOnGround()) {
            return;
        }
        if (!event.getPlayer().hasPermission("tweaks.command.back")) {
            return;
        }
        if (!this.isSafe(event.getFrom().getBlock())) {
            return;
        }
        this.plugin.backController().setLastSafeLocation(event.getPlayer(), event.getFrom());
    }

    private boolean isSafe(Block block) {
        Block down = block.getRelative(BlockFace.DOWN);
        if (this.isDangerousOn(down)) {
            return false;
        }
        if (this.isDangerousIn(block) || !block.isPassable()) {
            return false;
        }
        for (BlockFace face : this.faces) {
            if (!this.isDangerousIn(block.getRelative(face))) continue;
            return false;
        }
        return true;
    }

    private boolean isDangerousOn(Block block) {
        boolean bl;
        block5: {
            block4: {
                block3: {
                    if (!block.isCollidable()) break block3;
                    switch (block.getType()) {
                        case MAGMA_BLOCK: 
                        case POINTED_DRIPSTONE: 
                        case CAMPFIRE: 
                        case SOUL_CAMPFIRE: 
                        case BIG_DRIPLEAF: {
                            break;
                        }
                        default: {
                            break block4;
                        }
                    }
                }
                bl = true;
                break block5;
            }
            bl = false;
        }
        return bl;
    }

    private boolean isDangerousIn(Block block) {
        boolean bl;
        block5: {
            block4: {
                block3: {
                    if (block.isLiquid()) break block3;
                    switch (block.getType()) {
                        case END_PORTAL: 
                        case NETHER_PORTAL: 
                        case END_GATEWAY: 
                        case FIRE: 
                        case SOUL_FIRE: 
                        case WITHER_ROSE: {
                            break;
                        }
                        default: {
                            break block4;
                        }
                    }
                }
                bl = true;
                break block5;
            }
            bl = false;
        }
        return bl;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onTeleport(PlayerTeleportEvent event) {
        switch (event.getCause()) {
            default: {
                throw new MatchException(null, null);
            }
            case NETHER_PORTAL: 
            case ENDER_PEARL: 
            case COMMAND: 
            case END_GATEWAY: 
            case PLUGIN: 
            case SPECTATE: 
            case UNKNOWN: 
            case END_PORTAL: {
                break;
            }
            case CONSUMABLE_EFFECT: 
            case DISMOUNT: 
            case EXIT_BED: {
                return;
            }
        }
        Player player = event.getPlayer();
        if (!player.hasPermission("tweaks.command.back")) {
            return;
        }
        if (event.getCause().equals((Object)PlayerTeleportEvent.TeleportCause.COMMAND) && event.getTo().equals((Object)this.plugin.backController().getLock(player))) {
            this.plugin.backController().unlock(player);
            return;
        }
        Location location = this.isSafe(event.getFrom().getBlock()) ? event.getFrom() : this.plugin.backController().getLastSafeLocation(player);
        this.plugin.backController().offerFirst(player, location != null ? location : event.getFrom());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDeath(PlayerDeathEvent event) {
        if (event.getDamageSource().getDamageType().equals((Object)DamageType.OUT_OF_WORLD)) {
            return;
        }
        Player player = event.getPlayer();
        if (!player.hasPermission("tweaks.command.back")) {
            return;
        }
        Location location = player.getLocation();
        this.plugin.backController().offerFirst(player, location);
        Location last = this.isSafe(location.getBlock()) ? location : this.plugin.backController().getLastSafeLocation(player);
        this.plugin.backController().offerFirst(player, last != null ? last : location);
    }
}

