/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.controller;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.tweaks.TweaksPlugin;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class TPAController {
    private final Map<Player, Set<Request>> requests = new WeakHashMap<Player, Set<Request>>();
    private final TweaksPlugin plugin;

    public TPAController(TweaksPlugin plugin) {
        this.plugin = plugin;
    }

    public void removeRequests(Player player) {
        this.requests.values().forEach(requests -> requests.removeIf(request -> request.player().equals((Object)player)));
        this.requests.values().removeIf(Collection::isEmpty);
        this.requests.remove(player);
    }

    public Optional<Request> getRequest(Player player, Player target) {
        return this.getRequests(player).stream().filter(request -> request.player().equals((Object)target)).findAny();
    }

    public List<Request> getRequests(Player player) {
        Set<Request> requests = this.requests.get(player);
        if (requests == null) {
            return List.of();
        }
        return List.copyOf(requests);
    }

    public boolean addRequest(Player player, Player sender, RequestType type) {
        Set players = this.requests.computeIfAbsent(player, ignored -> new HashSet());
        return players.stream().noneMatch(request -> request.player().equals((Object)sender)) && players.add(new Request(sender, type));
    }

    public void expireRequest(Player player, Player sender, RequestType type) {
        if (!this.removeRequest(player, sender, type)) {
            return;
        }
        this.plugin.bundle().sendMessage((Audience)sender, "command.tpa.timeout.self", new TagResolver[]{Placeholder.parsed((String)"player", (String)player.getName())});
        this.plugin.bundle().sendMessage((Audience)player, "command.tpa.timeout", new TagResolver[]{Placeholder.parsed((String)"player", (String)sender.getName())});
    }

    public boolean removeRequest(Player sender, Player player, RequestType type) {
        boolean result;
        Set<Request> players = this.requests.get(sender);
        boolean bl = result = players != null && players.removeIf(request -> request.player().equals((Object)player) && request.type() == type);
        if (players != null && players.isEmpty()) {
            this.requests.remove(sender);
        }
        return result;
    }

    public record Request(Player player, RequestType type) {
    }

    public static enum RequestType {
        TPA_HERE("command.tpa.here.incoming", "command.tpa.here.outgoing"),
        TPA("command.tpa.incoming", "command.tpa.outgoing");

        private final String incomingMessage;
        private final String outgoingMessage;

        private RequestType(String incomingMessage, String outgoingMessage) {
            this.incomingMessage = incomingMessage;
            this.outgoingMessage = outgoingMessage;
        }

        public String incomingMessage() {
            return this.incomingMessage;
        }

        public String outgoingMessage() {
            return this.outgoingMessage;
        }
    }
}

