/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.controller;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import net.thenextlvl.tweaks.TweaksPlugin;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class BackController {
    private final Map<UUID, BlockingDeque<Location>> positions = new ConcurrentHashMap<UUID, BlockingDeque<Location>>();
    private final Map<UUID, Location> positionLock = new ConcurrentHashMap<UUID, Location>();
    private final Map<UUID, Location> lastSafeLocation = new ConcurrentHashMap<UUID, Location>();
    private final TweaksPlugin plugin;

    public BackController(TweaksPlugin plugin) {
        this.plugin = plugin;
    }

    public @Nullable Location peekFirst(Player player) {
        BlockingDeque<Location> deque = this.positions.get(player.getUniqueId());
        if (deque == null) {
            return null;
        }
        deque.removeIf(location -> !location.isWorldLoaded());
        return (Location)deque.peekFirst();
    }

    public void setLastSafeLocation(Player player, Location location) {
        this.lastSafeLocation.put(player.getUniqueId(), location);
    }

    public @Nullable Location getLastSafeLocation(Player player) {
        return this.lastSafeLocation.get(player.getUniqueId());
    }

    public void offerFirst(Player player, Location location) {
        this.positions.computeIfAbsent(player.getUniqueId(), ignored -> new LinkedBlockingDeque(this.plugin.config().general.backBufferStackSize)).offerFirst(location);
    }

    public void remove(Player player, Location location) {
        this.positions.computeIfPresent(player.getUniqueId(), (ignored, locations) -> locations.remove(location) && locations.isEmpty() ? null : locations);
    }

    public void remove(Player player) {
        this.positionLock.remove(player.getUniqueId());
        this.positions.remove(player.getUniqueId());
    }

    public @Nullable Location getLock(Player player) {
        return this.positionLock.get(player.getUniqueId());
    }

    public void lock(Player player, Location location) {
        this.positionLock.put(player.getUniqueId(), location);
    }

    public void unlock(Player player) {
        this.positionLock.remove(player.getUniqueId());
    }
}

