/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.command.warp;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.thenextlvl.tweaks.TweaksPlugin;
import net.thenextlvl.tweaks.gui.WarpGUI;
import net.thenextlvl.tweaks.model.NamedLocation;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class WarpsCommand {
    private final TweaksPlugin plugin;

    public WarpsCommand(TweaksPlugin plugin) {
        this.plugin = plugin;
    }

    public void register(Commands registrar) {
        LiteralCommandNode command = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)this.plugin.commands().warps.command).requires(stack -> stack.getSender().hasPermission("tweaks.command.warp"))).executes(this::warps)).build();
        registrar.register(command, "List all available warps", this.plugin.commands().warps.aliases);
    }

    private int warps(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        ((CompletableFuture)this.plugin.warpController().getWarps().thenAccept(warps -> {
            if (warps.isEmpty()) {
                this.plugin.bundle().sendMessage((Audience)sender, "command.warp.empty");
            } else if (this.plugin.config().guis.warps.enabled && sender instanceof Player) {
                Player player = (Player)sender;
                player.getScheduler().run((Plugin)this.plugin, task -> new WarpGUI(this.plugin, player, (Collection<NamedLocation>)warps).open(), null);
            } else {
                List<TextComponent> list = warps.stream().map(warp -> {
                    ClickEvent event = ClickEvent.runCommand((String)("/warp " + warp.getName()));
                    return (TextComponent)((TextComponent)Component.text((String)warp.getName()).hoverEvent((HoverEventSource)HoverEvent.showText((Component)this.plugin.bundle().component("chat.click.teleport", (Audience)sender)))).clickEvent(event);
                }).toList();
                this.plugin.bundle().sendMessage((Audience)sender, "command.warp.list", Formatter.number((String)"amount", (Number)warps.size()), Formatter.joining((String)"warps", list));
            }
        })).exceptionally(throwable -> {
            this.plugin.getComponentLogger().error("Failed to retrieve warps", throwable);
            return null;
        });
        return 1;
    }
}

