/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.command.warp;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.tweaks.TweaksPlugin;
import net.thenextlvl.tweaks.command.suggestion.WarpSuggestionProvider;
import org.bukkit.GameRules;
import org.bukkit.World;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class DeleteWarpCommand {
    private final TweaksPlugin plugin;

    public DeleteWarpCommand(TweaksPlugin plugin) {
        this.plugin = plugin;
    }

    public void register(Commands registrar) {
        LiteralCommandNode command = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)this.plugin.commands().deleteWarp.command).requires(stack -> stack.getSender().hasPermission("tweaks.command.warp.delete"))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new WarpSuggestionProvider(this.plugin)).executes(this::deleteWarp))).build();
        registrar.register(command, "Delete a warp point", this.plugin.commands().deleteWarp.aliases);
    }

    private int deleteWarp(CommandContext<CommandSourceStack> context) {
        String name = (String)context.getArgument("name", String.class);
        this.plugin.warpController().deleteWarp(name).thenAccept(success -> {
            World world = ((CommandSourceStack)context.getSource()).getLocation().getWorld();
            if (Boolean.FALSE.equals(world.getGameRuleValue(GameRules.SEND_COMMAND_FEEDBACK)) && success.booleanValue()) {
                return;
            }
            String message = success != false ? "command.warp.delete" : "command.warp.unknown";
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{Placeholder.parsed((String)"name", (String)name)});
        });
        return 1;
    }
}

