/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.command.player;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAccessor;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.tweaks.TweaksPlugin;
import net.thenextlvl.tweaks.command.suggestion.OfflinePlayerSuggestionProvider;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class SeenCommand {
    private final TweaksPlugin plugin;

    public SeenCommand(TweaksPlugin plugin) {
        this.plugin = plugin;
    }

    public void register(Commands registrar) {
        LiteralCommandNode command = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)this.plugin.commands().seen.command).requires(stack -> stack.getSender().hasPermission("tweaks.command.seen"))).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new OfflinePlayerSuggestionProvider(this.plugin)).executes(context -> {
            this.plugin.getServer().getAsyncScheduler().runNow((Plugin)this.plugin, task -> this.seen((CommandContext<CommandSourceStack>)context));
            return 1;
        }))).build();
        registrar.register(command, "Gives you information about a player", this.plugin.commands().seen.aliases);
    }

    private void seen(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        String name = (String)context.getArgument("player", String.class);
        OfflinePlayer player = this.plugin.getServer().getOfflinePlayer(name);
        if (player.getPlayer() != null) {
            this.plugin.bundle().sendMessage((Audience)sender, "command.last.seen.now", new TagResolver[]{Placeholder.parsed((String)"player", (String)(player.getName() != null ? player.getName() : name))});
            return;
        }
        if (!player.hasPlayedBefore()) {
            this.plugin.bundle().sendMessage((Audience)sender, "player.not.found", new TagResolver[]{Placeholder.parsed((String)"player", (String)(player.getName() != null ? player.getName() : name))});
            return;
        }
        Instant time = Instant.ofEpochMilli(player.getLastSeen());
        this.plugin.bundle().sendMessage((Audience)sender, "command.last.seen.time", new TagResolver[]{Placeholder.parsed((String)"player", (String)(player.getName() != null ? player.getName() : name)), Formatter.date((String)"date", (TemporalAccessor)LocalDateTime.ofInstant(time, ZoneId.systemDefault()))});
    }
}

