/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.command.environment.weather;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.tweaks.TweaksPlugin;
import org.bukkit.GameRules;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class WeatherCommand {
    private final TweaksPlugin plugin;

    public WeatherCommand(TweaksPlugin plugin) {
        this.plugin = plugin;
    }

    public void register(Commands registrar) {
        LiteralCommandNode command = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)this.plugin.commands().weather.command).requires(stack -> stack.getSender().hasPermission("tweaks.command.weather"))).then(this.setWeather("clear", "tweaks.command.weather.sun", this::clear))).then(this.setWeather("rain", "tweaks.command.weather.rain", this::rain))).then(this.setWeather("thunder", "tweaks.command.weather.thunder", this::thunder))).build();
        registrar.register(command, "Gives you an item of your choice", this.plugin.commands().weather.aliases);
    }

    private LiteralArgumentBuilder<CommandSourceStack> setWeather(String literal, String permission, Executor executor) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)literal).requires(stack -> stack.getSender().hasPermission(permission))).then(((RequiredArgumentBuilder)Commands.argument((String)"world", (ArgumentType)ArgumentTypes.world()).then(Commands.argument((String)"duration", (ArgumentType)ArgumentTypes.time((int)1)).executes(context -> {
            World world = (World)context.getArgument("world", World.class);
            Integer duration = (Integer)context.getArgument("duration", Integer.TYPE);
            executor.execute(((CommandSourceStack)context.getSource()).getSender(), world, duration);
            return 1;
        }))).executes(context -> {
            World world = (World)context.getArgument("world", World.class);
            executor.execute(((CommandSourceStack)context.getSource()).getSender(), world, -1);
            return 1;
        }))).executes(context -> {
            World world = ((CommandSourceStack)context.getSource()).getLocation().getWorld();
            executor.execute(((CommandSourceStack)context.getSource()).getSender(), world, -1);
            return 1;
        });
    }

    private void clear(CommandSender sender, World world, int duration) {
        this.setWeatherParameters(sender, world, false, false, duration, "command.weather.sun");
    }

    private void rain(CommandSender sender, World world, int duration) {
        this.setWeatherParameters(sender, world, true, false, duration, "command.weather.rain");
    }

    private void thunder(CommandSender sender, World world, int duration) {
        this.setWeatherParameters(sender, world, true, true, duration, "command.weather.thunder");
    }

    private void setWeatherParameters(CommandSender sender, World world, boolean rain, boolean thunder, int duration, String message) {
        this.plugin.getServer().getGlobalRegionScheduler().run((Plugin)this.plugin, task -> {
            world.setStorm(rain);
            world.setThundering(thunder);
            if (rain || thunder) {
                world.setWeatherDuration(duration);
            } else {
                world.setClearWeatherDuration(duration);
            }
        });
        if (Boolean.TRUE.equals(world.getGameRuleValue(GameRules.SEND_COMMAND_FEEDBACK))) {
            this.plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Formatter.number((String)"duration", (Number)duration), Placeholder.parsed((String)"world", (String)world.getName())});
        }
    }

    private static interface Executor {
        public void execute(CommandSender var1, World var2, int var3);
    }
}

