/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.listener;

import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.tweaks.TweaksPlugin;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class ConnectionListener
implements Listener {
    private final TweaksPlugin plugin;

    public ConnectionListener(TweaksPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onJoin(PlayerJoinEvent event) {
        byte permissionLevel = this.plugin.config().general.defaultPermissionLevel;
        if (permissionLevel != -1) {
            event.getPlayer().sendOpLevel(permissionLevel);
        }
        if (!this.plugin.config().general.overrideJoinMessage) {
            return;
        }
        int id = event.getPlayer().hasPlayedBefore() ? this.plugin.getServer().getOnlinePlayers().size() : this.plugin.getServer().getOfflinePlayers().length;
        String message = event.getPlayer().hasPlayedBefore() ? "player.connected" : "player.welcome";
        TagResolver resolvers = this.plugin.serviceResolvers(event.getPlayer()).resolver(Formatter.number((String)"id", (Number)id)).build();
        this.plugin.getServer().forEachAudience(audience -> this.plugin.bundle().sendMessage((Audience)audience, message, resolvers));
        event.joinMessage(null);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (!this.plugin.config().general.overrideQuitMessage) {
            return;
        }
        TagResolver resolvers = this.plugin.serviceResolvers(event.getPlayer()).build();
        this.plugin.getServer().forEachAudience(audience -> this.plugin.bundle().sendMessage((Audience)audience, "player.disconnected", resolvers));
        event.quitMessage(null);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void cleanup(PlayerQuitEvent event) {
        this.plugin.msgController().removeConversations((CommandSender)event.getPlayer());
        this.plugin.tpaController().removeRequests(event.getPlayer());
        this.plugin.teleportController().remove(event.getPlayer());
        this.plugin.backController().remove(event.getPlayer());
    }
}

