/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.gui;

import core.paper.gui.PaginatedGUI;
import core.paper.item.ActionItem;
import core.paper.item.ItemBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.translation.Argument;
import net.thenextlvl.tweaks.TweaksPlugin;
import net.thenextlvl.tweaks.model.NamedLocation;
import net.thenextlvl.tweaks.model.PluginConfig;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;

@NullMarked
public abstract class NamedLocationGUI
extends PaginatedGUI<TweaksPlugin, NamedLocation> {
    private static final List<Material> materials = Arrays.stream(Material.values()).filter(material -> !material.isLegacy()).filter(Material::isItem).toList();
    private final Collection<NamedLocation> elements;
    private final PaginatedGUI.Pagination pagination;

    public NamedLocationGUI(TweaksPlugin plugin, PluginConfig.GUIConfig.GUI config, Player owner, Component title, Collection<NamedLocation> elements) {
        super(plugin, owner, title, config.rows);
        this.elements = elements;
        this.pagination = new PaginatedGUI.Pagination(config.actionSlots, config.buttonSlotPrevious, config.buttonSlotNext);
        this.loadPage(this.getCurrentPage());
    }

    @Override
    public Collection<NamedLocation> getElements() {
        return this.elements;
    }

    @Override
    public PaginatedGUI.Pagination getPagination() {
        return this.pagination;
    }

    @Override
    public ActionItem constructItem(NamedLocation element) {
        String translation = "gui.item.location";
        return ItemBuilder.of(this.getIcon(element)).itemName(((TweaksPlugin)this.plugin).bundle().component(translation, (Audience)this.owner, Argument.string((String)"name", (String)element.getName()))).withAction(() -> {
            this.teleport(element);
            this.close();
        });
    }

    private Material getIcon(NamedLocation element) {
        Material material = ((TweaksPlugin)this.plugin).config().guis.nameIcons.get(element.getName());
        if (material != null) {
            return material;
        }
        int hash = Math.abs(element.getName().hashCode());
        return materials.get(hash % materials.size());
    }

    protected abstract void teleport(NamedLocation var1);

    @Override
    public Component getPageFormat(int page) {
        String key = page > this.getCurrentPage() ? "gui.page.next" : "gui.page.previous";
        return ((TweaksPlugin)this.plugin).bundle().component(key, (Audience)this.owner);
    }
}

