/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.controller;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.thenextlvl.tweaks.TweaksPlugin;
import net.thenextlvl.tweaks.model.NamedLocation;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class HomeController {
    private final TweaksPlugin plugin;

    public HomeController(TweaksPlugin plugin) {
        this.plugin = plugin;
    }

    public CompletableFuture<Optional<Location>> getHome(OfflinePlayer player, String name) {
        return CompletableFuture.supplyAsync(() -> this.plugin.dataController().getHome(player, name));
    }

    public CompletableFuture<Set<NamedLocation>> getHomes(OfflinePlayer player) {
        return CompletableFuture.supplyAsync(() -> this.plugin.dataController().getHomes(player));
    }

    public CompletableFuture<Boolean> deleteHome(OfflinePlayer player, String name) {
        return CompletableFuture.supplyAsync(() -> this.plugin.dataController().deleteHome(player, name));
    }

    public int getMaxHomeCount(Player player) {
        return Optional.ofNullable(this.plugin.serviceController()).flatMap(controller -> controller.getMaxHomeCount(player)).orElse(this.plugin.config().homes.limit);
    }
}

