/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.command.tpa;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.event.ClickCallback;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.StyleBuilderApplicable;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.tweaks.TweaksPlugin;
import net.thenextlvl.tweaks.command.suggestion.TPASuggestionProvider;
import net.thenextlvl.tweaks.command.tpa.TPADenyCommand;
import net.thenextlvl.tweaks.command.tpa.TPAcceptCommand;
import net.thenextlvl.tweaks.controller.TPAController;
import org.bukkit.GameRule;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class TPAskCommand {
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private final TweaksPlugin plugin;

    public TPAskCommand(TweaksPlugin plugin) {
        this.plugin = plugin;
    }

    public void register(Commands commands) {
        LiteralCommandNode command = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)this.plugin.commands().teleportAsk.command).requires(stack -> {
            Player player;
            CommandSender patt0$temp = stack.getSender();
            return patt0$temp instanceof Player && (player = (Player)patt0$temp).hasPermission("tweaks.command.tpa");
        })).then(Commands.argument((String)"player", (ArgumentType)ArgumentTypes.player()).suggests((SuggestionProvider)new TPASuggestionProvider(this.plugin)).executes(this::ask))).build();
        commands.register(command, "Request to teleport to a player", this.plugin.commands().teleportAsk.aliases);
    }

    private int ask(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        PlayerSelectorArgumentResolver resolver;
        Player player;
        Player sender = (Player)((CommandSourceStack)context.getSource()).getSender();
        return TPAskCommand.ask(this.plugin, sender, player = (Player)((List)(resolver = (PlayerSelectorArgumentResolver)context.getArgument("player", PlayerSelectorArgumentResolver.class)).resolve((CommandSourceStack)context.getSource())).getFirst(), TPAController.RequestType.TPA) ? 1 : 0;
    }

    static boolean ask(TweaksPlugin plugin, Player sender, Player player, TPAController.RequestType type) {
        if (sender.equals((Object)player)) {
            plugin.bundle().sendMessage((Audience)sender, "command.tpa.self");
            return false;
        }
        if (plugin.dataController().isTpaToggled((OfflinePlayer)player)) {
            plugin.bundle().sendMessage((Audience)sender, "command.tpa.toggled", new TagResolver[]{Placeholder.parsed((String)"player", (String)player.getName())});
            return false;
        }
        boolean success = plugin.tpaController().addRequest(player, sender, type);
        if (Boolean.TRUE.equals(player.getWorld().getGameRuleValue(GameRule.SEND_COMMAND_FEEDBACK)) || !success) {
            plugin.bundle().sendMessage((Audience)sender, success ? type.outgoingMessage() : "command.tpa.sent", new TagResolver[]{Placeholder.parsed((String)"player", (String)player.getName())});
        }
        if (!success) {
            return false;
        }
        executor.schedule(() -> plugin.tpaController().expireRequest(player, sender, type), plugin.config().teleport.tpaTimeout, TimeUnit.MILLISECONDS);
        plugin.bundle().sendMessage((Audience)player, type.incomingMessage(), new TagResolver[]{Placeholder.parsed((String)"player", (String)sender.getName()), Placeholder.styling((String)"accept", (StyleBuilderApplicable[])new StyleBuilderApplicable[]{ClickEvent.callback(audience -> TPAcceptCommand.accept(plugin, player, sender, type), (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().lifetime((TemporalAmount)Duration.ofMillis(plugin.config().teleport.tpaTimeout)).uses(1).build()))}), Placeholder.styling((String)"deny", (StyleBuilderApplicable[])new StyleBuilderApplicable[]{ClickEvent.callback(audience -> TPADenyCommand.deny(plugin, player, sender, type), (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().lifetime((TemporalAmount)Duration.ofMillis(plugin.config().teleport.tpaTimeout)).uses(1).build()))}), Formatter.number((String)"time", (Number)TimeUnit.MILLISECONDS.toSeconds(plugin.config().teleport.tpaTimeout))});
        return true;
    }
}

