/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.command.player;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.nbt.NBTInputStream;
import net.thenextlvl.nbt.NBTOutputStream;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.nbt.tag.DoubleTag;
import net.thenextlvl.nbt.tag.FloatTag;
import net.thenextlvl.nbt.tag.ListTag;
import net.thenextlvl.nbt.tag.Tag;
import net.thenextlvl.tweaks.TweaksPlugin;
import net.thenextlvl.tweaks.command.suggestion.OfflinePlayerSuggestionProvider;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class OfflineTeleportCommand {
    private final TweaksPlugin plugin;

    public OfflineTeleportCommand(TweaksPlugin plugin) {
        this.plugin = plugin;
    }

    public void register(Commands registrar) {
        LiteralCommandNode command = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)this.plugin.commands().offlineTeleport.command).requires(stack -> stack.getSender().hasPermission("tweaks.command.offline-tp"))).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new OfflinePlayerSuggestionProvider(this.plugin)).then(Commands.argument((String)"target", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new OfflinePlayerSuggestionProvider(this.plugin)).executes(context -> {
            this.plugin.getServer().getAsyncScheduler().runNow((Plugin)this.plugin, task -> this.teleportOther((CommandContext<CommandSourceStack>)context));
            return 1;
        }))).executes(context -> {
            this.plugin.getServer().getAsyncScheduler().runNow((Plugin)this.plugin, task -> this.teleport((CommandContext<CommandSourceStack>)context));
            return 1;
        }))).build();
        registrar.register(command, "Teleport offline-players to others or you to them", this.plugin.commands().offlineTeleport.aliases);
    }

    private void teleportOther(CommandContext<CommandSourceStack> context) {
        OfflinePlayer target;
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        OfflinePlayer player = this.plugin.getServer().getOfflinePlayer((String)context.getArgument("player", String.class));
        String message = player.equals((Object)(target = this.plugin.getServer().getOfflinePlayer((String)context.getArgument("target", String.class)))) ? "command.offline.teleport.location" : this.teleport(player, target);
        this.plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.parsed((String)"source", (String)String.valueOf(player.getName())), Placeholder.parsed((String)"target", (String)String.valueOf(target.getName()))});
    }

    private void teleport(CommandContext<CommandSourceStack> context) {
        CommandSender commandSender = ((CommandSourceStack)context.getSource()).getSender();
        if (!(commandSender instanceof Player)) {
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "command.sender");
            return;
        }
        Player sender = (Player)commandSender;
        OfflinePlayer player = this.plugin.getServer().getOfflinePlayer((String)context.getArgument("player", String.class));
        TagResolver.Single placeholder = Placeholder.parsed((String)"player", (String)String.valueOf(player.getName()));
        ((CompletableFuture)((CompletableFuture)CompletableFuture.completedFuture(this.getLocation(player)).thenCompose(location -> {
            if (location != null) {
                return sender.teleportAsync(location, PlayerTeleportEvent.TeleportCause.COMMAND);
            }
            return CompletableFuture.completedFuture(false);
        })).thenAccept(success -> {
            if (Boolean.FALSE.equals(sender.getWorld().getGameRuleValue(GameRule.SEND_COMMAND_FEEDBACK))) {
                return;
            }
            String message = success != false ? "command.offline.teleport.success.to" : "command.offline.teleport.fail.to";
            this.plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{placeholder});
        })).exceptionally(throwable -> {
            this.plugin.bundle().sendMessage((Audience)sender, "command.offline.teleport.fail.to", new TagResolver[]{placeholder});
            this.plugin.getComponentLogger().error("Failed to teleport to offline player", throwable);
            return null;
        });
    }

    private String teleport(OfflinePlayer source, OfflinePlayer target) {
        Player online = source.getPlayer();
        Location location = this.getLocation(target);
        if (location == null) {
            return "command.offline.teleport.fail";
        }
        if (online == null) {
            return this.setLocation(source, location) ? "command.offline.teleport.success" : "command.offline.teleport.fail";
        }
        if (online.getLocation().equals((Object)location)) {
            return "command.offline.teleport.location";
        }
        online.teleportAsync(location, PlayerTeleportEvent.TeleportCause.COMMAND);
        return "command.offline.teleport.success";
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean setLocation(OfflinePlayer player, Location location) {
        Path file = this.getPlayerDataFile(player).orElse(null);
        if (file == null) {
            return false;
        }
        try (NBTInputStream input = NBTInputStream.create(file);){
            boolean bl;
            block15: {
                NBTOutputStream output = NBTOutputStream.create(file);
                try {
                    Map.Entry<String, CompoundTag> tag = input.readNamedTag();
                    output.writeTag(tag.getKey(), tag.getValue().toBuilder().putAll(this.toTag(location)).build());
                    bl = true;
                    if (output == null) break block15;
                }
                catch (Throwable throwable) {
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                output.close();
            }
            return bl;
        }
        catch (IOException e) {
            this.plugin.getComponentLogger().warn("Failed to set location of offline player", (Throwable)e);
            this.plugin.getComponentLogger().warn("Please look for similar issues or report this on GitHub: {}", (Object)"https://github.com/TheNextLvl-net/tweaks/issues/new?template=bug_report.yml");
            TweaksPlugin.ERROR_TRACKER.trackError(e);
            return false;
        }
    }

    private @Nullable Location fromTag(CompoundTag tag) {
        World world = this.getWorld(tag);
        if (world == null) {
            return null;
        }
        ListTag pos = tag.getAsList("Pos");
        double z = ((DoubleTag)pos.get(2)).getAsDouble();
        double y = ((DoubleTag)pos.get(1)).getAsDouble();
        double x = ((DoubleTag)pos.get(0)).getAsDouble();
        ListTag rotation = tag.getAsList("Rotation");
        float yaw = ((FloatTag)rotation.get(0)).getAsFloat();
        float pitch = ((FloatTag)rotation.get(1)).getAsFloat();
        return new Location(world, x, y, z, yaw, pitch);
    }

    private @Nullable World getWorld(CompoundTag tag) {
        Optional<Long> uuidLeast = tag.optional("WorldUUIDLeast").map(Tag::getAsLong);
        if (uuidLeast.isEmpty()) {
            return null;
        }
        Optional<Long> uuidMost = tag.optional("WorldUUIDMost").map(Tag::getAsLong);
        if (uuidMost.isEmpty()) {
            return null;
        }
        World world = Bukkit.getWorld((UUID)new UUID(uuidLeast.get(), uuidMost.get()));
        if (world != null) {
            return world;
        }
        Optional<String> dimension = tag.optional("Dimension").map(Tag::getAsString);
        Optional<NamespacedKey> key = dimension.map(NamespacedKey::fromString);
        return key.map(Bukkit::getWorld).orElse(null);
    }

    private CompoundTag toTag(Location location) {
        ListTag<DoubleTag> pos = ListTag.builder().add(DoubleTag.of(location.getX())).add(DoubleTag.of(location.getY())).add(DoubleTag.of(location.getZ())).build();
        ListTag<FloatTag> rotation = ListTag.builder().add(FloatTag.of(location.getYaw())).add(FloatTag.of(location.getPitch())).build();
        return CompoundTag.builder().put("WorldUUIDLeast", (Number)location.getWorld().getUID().getLeastSignificantBits()).put("WorldUUIDMost", (Number)location.getWorld().getUID().getMostSignificantBits()).put("Dimension", location.getWorld().key().asString()).put("Pos", pos).put("Rotation", rotation).build();
    }

    private @Nullable Location getLocation(OfflinePlayer player) {
        Location location;
        block9: {
            Player online = player.getPlayer();
            if (online != null) {
                return online.getLocation();
            }
            NBTInputStream file = this.readPlayerData(player);
            try {
                Location location2 = location = file != null ? this.fromTag(file.readTag()) : null;
                if (file == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (file != null) {
                        try {
                            file.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.plugin.getComponentLogger().warn("Failed to get location of offline player", (Throwable)e);
                    this.plugin.getComponentLogger().warn("Please look for similar issues or report this on GitHub: {}", (Object)"https://github.com/TheNextLvl-net/tweaks/issues/new?template=bug_report.yml");
                    TweaksPlugin.ERROR_TRACKER.trackError(e);
                    return null;
                }
            }
            file.close();
        }
        return location;
    }

    private Optional<Path> getPlayerDataFolder() {
        Key overworld = Key.key((String)"minecraft", (String)"overworld");
        return Optional.ofNullable(this.plugin.getServer().getWorld(overworld)).map(world -> world.getWorldFolder().toPath().resolve("playerdata"));
    }

    private Optional<Path> getPlayerDataFile(OfflinePlayer player) {
        return this.getPlayerDataFolder().map(path -> path.resolve(String.valueOf(player.getUniqueId()) + ".dat")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).or(() -> this.getPlayerDataFolder().map(path -> path.resolve(String.valueOf(player.getUniqueId()) + ".dat_old")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])));
    }

    private @Nullable NBTInputStream readPlayerData(OfflinePlayer player) throws IOException {
        Path file = this.getPlayerDataFile(player).orElse(null);
        return file != null ? NBTInputStream.create(file) : null;
    }
}

