/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.command.player;

import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import net.kyori.adventure.audience.Audience;
import net.thenextlvl.tweaks.TweaksPlugin;
import net.thenextlvl.tweaks.command.player.PlayerCommand;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class EnderChestCommand
extends PlayerCommand
implements Listener {
    private final Set<HumanEntity> viewers = Collections.newSetFromMap(new WeakHashMap());

    public EnderChestCommand(TweaksPlugin plugin) {
        super(plugin);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void register(Commands registrar) {
        LiteralCommandNode command = this.create(this.plugin.commands().enderchest.command, "tweaks.command.enderchest", "tweaks.command.enderchest.others");
        registrar.register(command, "Open your own or someone else's enderchest", this.plugin.commands().enderchest.aliases);
    }

    @Override
    protected int execute(CommandSender sender, Player target) {
        if (!(sender instanceof Player)) {
            this.plugin.bundle().sendMessage((Audience)sender, "command.sender");
            return 0;
        }
        Player player = (Player)sender;
        if (!player.equals((Object)target)) {
            this.viewers.add((HumanEntity)player);
        }
        player.openInventory(target.getEnderChest());
        return 1;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInventoryClose(InventoryCloseEvent event) {
        this.viewers.remove(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getWhoClicked().hasPermission("tweaks.command.enderchest.edit")) {
            return;
        }
        if (this.viewers.contains(event.getWhoClicked())) {
            event.setCancelled(true);
        }
    }
}

