/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.command.home;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.thenextlvl.tweaks.TweaksPlugin;
import net.thenextlvl.tweaks.gui.HomeGUI;
import net.thenextlvl.tweaks.model.NamedLocation;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class HomesCommand {
    private final TweaksPlugin plugin;

    public HomesCommand(TweaksPlugin plugin) {
        this.plugin = plugin;
    }

    public void register(Commands registrar) {
        LiteralCommandNode command = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)this.plugin.commands().homes.command).requires(stack -> {
            Player player;
            CommandSender patt0$temp = stack.getSender();
            return patt0$temp instanceof Player && (player = (Player)patt0$temp).hasPermission("tweaks.command.home");
        })).executes(this::homes)).build();
        registrar.register(command, "List all of your homes", this.plugin.commands().homes.aliases);
    }

    private int homes(CommandContext<CommandSourceStack> context) {
        Player sender = (Player)((CommandSourceStack)context.getSource()).getSender();
        ((CompletableFuture)this.plugin.homeController().getHomes((OfflinePlayer)sender).thenAccept(homes -> {
            if (homes.isEmpty()) {
                this.plugin.bundle().sendMessage((Audience)sender, "command.home.undefined");
            } else if (this.plugin.config().guis.homes.enabled) {
                sender.getScheduler().run((Plugin)this.plugin, task -> new HomeGUI(this.plugin, sender, (Collection<NamedLocation>)homes).open(), null);
            } else {
                List<TextComponent> list = homes.stream().map(home -> {
                    ClickEvent event = ClickEvent.runCommand((String)("/home " + home.getName()));
                    return (TextComponent)((TextComponent)Component.text((String)home.getName()).hoverEvent((HoverEventSource)HoverEvent.showText((Component)this.plugin.bundle().component("chat.click.teleport", (Audience)sender)))).clickEvent(event);
                }).toList();
                this.plugin.bundle().sendMessage((Audience)sender, "command.home.list", Formatter.number((String)"amount", (Number)homes.size()), Formatter.joining((String)"homes", list));
            }
        })).exceptionally(throwable -> {
            this.plugin.getComponentLogger().error("Failed to retrieve homes", throwable);
            return null;
        });
        return 1;
    }
}

