/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.command.server;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.tweaks.TweaksPlugin;
import org.bukkit.command.CommandSender;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class MotdCommand {
    private final TweaksPlugin plugin;

    public MotdCommand(TweaksPlugin plugin) {
        this.plugin = plugin;
    }

    public void register(Commands registrar) {
        LiteralCommandNode command = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)this.plugin.commands().motd.command).requires(stack -> stack.getSender().hasPermission("tweaks.command.motd"))).then(Commands.literal((String)"replace").then(Commands.argument((String)"text", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"replacement", (ArgumentType)StringArgumentType.greedyString()).executes(this::replace))))).then(Commands.literal((String)"set").then(Commands.argument((String)"motd", (ArgumentType)StringArgumentType.greedyString()).executes(this::set)))).then(Commands.literal((String)"clear").executes(this::clear))).then(Commands.literal((String)"get").executes(this::get))).build();
        registrar.register(command, "Change the motd of the server", this.plugin.commands().motd.aliases);
    }

    private int replace(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        String motd = this.plugin.config().general.motd;
        if (motd == null) {
            this.plugin.bundle().sendMessage((Audience)sender, "command.motd.none");
            return 0;
        }
        String message = (String)context.getArgument("text", String.class);
        String replacement = (String)context.getArgument("replacement", String.class);
        String newMotd = motd.replace(message, replacement);
        return this.updateMotd(sender, newMotd);
    }

    private int clear(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        return this.updateMotd(sender, null);
    }

    private int get(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        String motd = this.plugin.config().general.motd;
        String message = motd != null ? "command.motd" : "command.motd.none";
        this.plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.parsed((String)"motd", (String)String.valueOf(motd))});
        return 1;
    }

    private int set(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        String motd = (String)context.getArgument("motd", String.class);
        return this.updateMotd(sender, motd);
    }

    private int updateMotd(CommandSender sender, @Nullable String motd) {
        TextComponent message = motd == null ? Component.text((String)"A Minecraft Server") : MiniMessage.miniMessage().deserialize((Object)motd);
        this.plugin.bundle().sendMessage((Audience)sender, "command.motd.changed", new TagResolver[]{Placeholder.component((String)"motd", (ComponentLike)message)});
        this.plugin.config().general.motd = motd;
        this.plugin.saveConfig();
        this.plugin.getServer().motd((Component)message);
        return 1;
    }
}

